<?php

namespace App\Http\Controllers;

use App\Advertisement;
use App\Language;
use App\Notification;
use App\Notifications\OrderNotification;
use App\Option;
use App\Order;
use App\Post;
use App\Rating;
use App\Service;
use App\State;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Mockery\Exception;

class APIController extends Controller
{
    public function getOptions()
    {
        $user = Auth::user();
        if ($user->status == "blocked") {
            $data["block_status"] = false;
            return response()->json($data, 200);
        }

        $ordersTypes = Option::where("type", "type_of_freight")->get();
        $data["ordersTypes"] = call_user_func(array("App\\Http\\Resources\\OptionResource", 'collection'), $ordersTypes);

        $typeOfPayment = Option::where("type", "type_of_payment")->get();
        $data["typeOfPayment"] = call_user_func(array("App\\Http\\Resources\\OptionResource", 'collection'), $typeOfPayment);;

        return \response()->json($data, 200);
    }

    public function privacy()
    {
        

        $privacy = Post::where("type", "privacy")->get();
        $data["privacy"] = call_user_func(array("App\\Http\\Resources\\PostResource", 'collection'), $privacy);

        $aboutsUs = Post::where("type", "about")->get();
        $data["aboutsUs"] = call_user_func(array("App\\Http\\Resources\\PostResource", 'collection'), $aboutsUs);


        return \response()->json($data, 200);
    }

    public function getNotifications()
    {
        $notifications = Notification::where("user_id", Auth::user()->id)->orderBy('created_at', 'DESC')->get();
        $data["notifications"] = call_user_func(array("App\\Http\\Resources\\NotificationResource", 'collection'), $notifications);

        return \response()->json($data, 200);
    }

    public function newOrder(Request $request)
    {

        $user = Auth::user();
        $validator = Validator::make($request->all(), [
            "type" => "required",
            "type_of_payment" => "required",
            "from" => "required",
            "to" => "required",
            "name" => "required",
            "mobile" => "required",
            "is_breakable" => "required",
            "number_of_packages" => "required",
            "package_content" => "required",
        ]);

        if ($validator->fails()) {
            $data["message"] = $validator->errors();
            $data["status"] = false;
            return \response()->json($data, 200);
        }

        try {
            $order = new Order($request->all());
            $order->client_id = $user->id;
            $order->status = "pending";

            $height = $request->height;
            $length = $request->length;
            $width = $request->width;
            $weight = $request->weight;
            $size = 0;

            if ($request->has("height") && $request->has("length") && $request->has("weight")) {
                $order->height = $height;
                $order->length = $length;
                $order->width = $width;
                $order->weight = $weight;
                $size = $length * $width * $height;
            }

            $order->size = $size;
            $order->save();

            $type = "new order";
            $title_en = "Your order has been sent successfully";
            $title_ar = "لقد  تم  ارسال طلبك  بنجاح";
            $body_en = "We will tell you about details of your order";
            $body_ar = "سوف نقوم  باخبارك  بتفاصيل طلبك.";

            $notification = storeNotification($request, $user, $order, $type, $title_en, $title_ar, $body_en, $body_ar);

            $user->notify(new OrderNotification($notification, $order->user, $order));

            $data["order"] = $order;
            $data["message"] = trans("app.sent successfully");
            $data["status"] = true;
            return \response()->json($data, 200);
        } catch (Exception $exception) {
            $data["message"] = $exception;
            $data["status"] = false;
            return \response()->json($data, 200);
        }
    }

    public function serviceDetails(Request $request)
    {
        $user = Auth::user();
        if ($user->status == "blocked") {
            $data["block_status"] = false;
            return response()->json($data, 200);
        }

        if ($request->has("service_id")) {
            $service = Service::where("id", $request->service_id)->get();
            $data["service"] = call_user_func(array("App\\Http\\Resources\\ServiceResource", 'collection'), $service);
            $data["status"] = true;
        } else {

            $services = Service::all();
            $data["services"] = call_user_func(array("App\\Http\\Resources\\ServiceResource", 'collection'), $services);

        }

        $advertisements = Advertisement::all();
        $data["advertisements"] = call_user_func(array("App\\Http\\Resources\\AdvertisementResource", 'collection'), $advertisements);
        $data["status"] = true;

        return \response()->json($data, 200);

    }

    public function getOrders(Request $request)
    {
        $user = Auth::user();
        if ($user->status == "blocked") {
            $data["block_status"] = false;
            return response()->json($data, 200);
        }

        $data = [];
        if ($request->has("order_id")) {
            $order = Order::where("client_id", Auth::user()->id)->where("id", $request->order_id)->orderBy('created_at', 'DESC')->get();
            $data["order"] = call_user_func(array("App\\Http\\Resources\\OrderResource", 'collection'), $order);
            $data["status"] = true;
        } elseif ($request->has("status")) {
            $orders = Order::where("client_id", Auth::user()->id)->where("status", $request->status)->orderBy('created_at', 'DESC')->get();
            $data["orders"] = call_user_func(array("App\\Http\\Resources\\OrderResource", 'collection'), $orders);
            $data["status"] = true;
        }

        return \response()->json($data, 200);
    }

    public function orderUpdate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "order_id" => "required"
        ]);

        if ($validator->fails()) {
            $data["message"] = $validator->errors();
            $data["status"] = false;
            return response()->json($data, 200);
        }

        $order = Order::where("id", $request->order_id)->first();
        $order->status = "delivery";
        $order->save();

        $type = "delivery_order";
        $title_en = "On Delivery";
        $title_ar = "قيد التوصيل";
        $details_en = "Your order in delivery";
        $details_ar = "إن طلبكم قيد التوصيل";


        $notification = new State();
        $notification->fill($request->except($notification->translatable));
        if (!is_null($notification->translatable)) {
            foreach ($notification->translatable as $attr) {
                $trans = [];
                foreach (Language::all() as $language) {
                    $var = $attr . "_" . $language->code;
                    if ($var == "title_ar") {
                        $trans[$language->code] = $title_ar;
                    } elseif ($var == "details_ar") {
                        $trans[$language->code] = $details_ar;
                    } elseif ($var == "title_en") {
                        $trans[$language->code] = $title_en;
                    } elseif ($var == "details_en") {
                        $trans[$language->code] = $details_en;
                    }
                }
                $notification->$attr = $trans;
            }
        }

        $notification->status = $order->status;
        $notification->user_id = $order->user->id;
        $notification->order_id = $order->id;
        $notification->save();


        $updatedOrder = Order::where("id", $request->order_id)->get();

        $data["order"] = call_user_func(array("App\\Http\\Resources\\OrderResource", 'collection'), $updatedOrder);
        $data["status"] = true;
        return response()->json($data, 200);
    }

    public function orderRating(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "order_id" => "required",
            "rating" => "required"
        ]);

        if ($validator->fails()) {
            $data["message"] = $validator->errors();
            $data["status"] = false;
            return response()->json($data, 200);
        }

        $order = Order::where("id", $request->order_id)->first();

        $order->rating = $request->rating;
        if ($request->has("description"))
            $order->discreption = $request->description;
        $order->save();

        $rating = new Rating();
        $rating->rating = $request->rating;
        if ($request->has("description"))
            $rating->description = $request->description;

        $rating->user_id = Auth::user()->id;
        $rating->order_id = $order->id;
        $rating->save();

        $data["order"] = $order;
        $data["status"] = true;
        return \response()->json($data, 200);
    }

    public function storeImage(Request $request)
    {
        if ($request->que)
            $imageName = "";
        $image = $request->input('image');  // your base64 encoded
        $image = str_replace('data:image/png;base64,', '', $image);
        $image = str_replace(' ', '+', $image);
        $imageName = Str::random(10) . '.' . 'png';
        Storage::disk('public')->put($imageName, base64_decode($image));

        return $imageName;
    }

    public function getCode(Request $request)
    {
        $mobile = $request->mobile;
        $user = User::where('mobile', $mobile)->first();
        try {
            if ($user) {
                $code = generateRandomString(6);
                $user->password = '123456';
                $user->verify_code = $code;
                $user->save();
                $data['message'] = trans('your code is: ' . $code);
                 $data['code'] = $code;
                $data['status'] = 1;
            } else {
                $user = new User();
                $user->mobile = $mobile;
                $code = generateRandomString(6);
                $user->password = bcrypt('123456');
                $user->verify_code = $code;
                $user->role = 'user';
                $user->lang = 'ar';
                $user->save();
                $data['message'] = trans('your code is: ' . $code);
                $data['code'] = $code;
                $data['status'] = 0;
                $data['user'] = $user;
            }

            return response()->json($data, 200);
        } catch (Exception $exception) {
            $data["message"] = $exception;
            $data["status"] = false;
            return \response()->json($data, 500);
        }

    }

      public function checkCode(Request $request)
    {
		  
		  $validator = Validator::make($request->all(), [
           "mobile"=> "required",
			"code" => "required"
        ] , [
			  "code.required" => "كود تسجيل الدخول مطلوب"
		  ]);

        if ($validator->fails()) {
            $data["message"] = $validator->errors();
            $data["status"] = false;
            return response($data, 422);
        }
		  
        $user = User::where('mobile', $request->mobile)->where('verify_code', $request->code)->first();
        if ($user) {
            $data["token"] = $user->createToken('authToken')->accessToken;
            $data['user'] = $user;
			$data["status"] = true;
        
            return response()->json($data, 200);
        } else {

            $data["status"] = false;
            $data["message"] = 'Wrong Credentials';
            return response()->json($data, 401);
        }


    }
}
