<?php

namespace App\Http\Controllers;

use App\Http\Resources\UserResource;
use App\Language;
use App\Notification;
use App\Notifications\LoginNotification;
use App\Notifications\RegisterNotification;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class AuthController extends Controller
{
    public function register(Request $request)
    {
        $validator = Validator::make($request->all(), [
           "mobile"=> "required",
        ]);

        if ($validator->fails()) {
            $data["message"] = $validator->errors();
            $data["status"] = false;
            return response($data, 200);
        }


        try {
            $verify_code = random_int(100000, 999999);

            $user = new User($request->all());
            $user->password = bcrypt("123456");
            $user->role = "user";
            $user->status = "online";
            $user->fcm_token = $request->fcm_token;
            $user->verify_code = $verify_code;
            if ($request->has("image")) {
                $user->image =  $this->storeImage($request);
            }
            if ($request->has("lang")) {
                $user->lang = $request->lang;
            }
            $user->save();

            $accessToken  = $user->createToken('authToken')->accessToken;

            $data["user"] = new UserResource($user);
            $data["token"] = $accessToken;

            // $type = "new_account";
            // $title_en = "New Account has been created";
            // $title_ar = "تم  إنشاء الحساب بنجاح.";
            // $body_en = "Thank you for using our program.";
            // $body_ar = "شكرا لاستخدامكم تطبيقنا لإن رمز التأكيد هو : .";

            // $notification = new Notification();
            // $notification->fill($request->except($notification->translatable));
            // if (!is_null($notification->translatable)) {
            //     foreach ($notification->translatable as $attr) {
            //         $trans = [];
            //         foreach (Language::all() as $language) {
            //             $var = $attr . "_" . $language->code;
            //             if ($var == "title_ar") {
            //                 $trans[$language->code] = $title_ar;
            //             } elseif ($var == "body_ar") {
            //                 $trans[$language->code] = $body_ar;
            //             } elseif ($var == "title_en") {
            //                 $trans[$language->code] = $title_en;
            //             } elseif ($var == "body_en") {
            //                 $trans[$language->code] = $body_en;
            //             }
            //         }
            //         $notification->$attr = $trans;
            //     }
            // }

            // $notification->type = $type;
            // $notification->user_id = $user->id;
            // $notification->save();

            // $user->notify(new RegisterNotification($notification, $user));
            $data["status"] = true;
            return response()->json($data, 200);

        } catch (\Exception $e) {
            $data["message"] = $e;
            $data["status"] = false;
            return response($data, 200);
        }
    }

    public function checkNumber(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile' => 'required|unique:users',
        ]);

        if ($validator->fails()) {
            $data["message"] = $validator->errors()->first();
            $data["status"] = true;
            return response()->json($data, 200);
        }
		
		$user = User::where('mobile',$request->mobile)->first();
		if($user){
			  $data["message"] = trans('app.number exist');
            $data["status"] = true;
            return response()->json($data, 200);
		}else{
			$data["message"] = trans('app.number_not_exist');
           $data["status"] = false;
            return response()->json($data, 200);
		}

     

    }

    public function login(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile' => 'required',
        ]);

        if ($validator->fails()) {
            $data["message"] = $validator->errors()->first();
            $data["status"] = true;
            return response()->json($data, 200);
        }

       // try{
       //     $verify_code = random_int(100000, 999999);

      //  }catch (\Exception $e)
       // {
      //      $data["message"] = $e;
      //      $data["status"] = false;
      //      return response($data, 200);
      //  }

        $user = User::where("mobile", $request->mobile)->first();

        if ($user->status  == "blocked") {
            $data["block_status"] = false;
            return response()->json($data, 200);
        }

        if ($user == null) {
            $data["message"] = trans("app.wrong credentials");
            $data["status"] =false;
            return response()->json($data, 200);
        }

        if ($request->has("fcm_token")) {
            $user->fcm_token = $request->fcm_token;
        }

        if ($request->has("lang")) {
            $user->lang = $request->lang;
        }

       // $user->verify_code = $verify_code;
        $user->save();


        //$user->notify(new LoginNotification($verify_code, $user));

        $data["user"] = new UserResource($user);
        $data["token"] = $user->createToken('authToken')->accessToken;
        $data["status"] = true;

        return response()->json($data, 200);
    }

    public function logout(Request $request)
    {
        $user = Auth::user();
        $user->fcm_token = null;
        $user->save();
        $token = $request->user()->token();
        $token->revoke();
        $response = ['message' => 'You have been successfully logged out!'];
        return response($response, 200);
    }

    public function fcmToken(Request $request)
    {
        $validator  = Validator::make($request->all(), [
           'fcm_token'=>'required'
        ]);

        if ($validator->fails()) {
            $data["message"] = $validator->errors();
            $data["status"] = false;
            return response()->json($data, 200);
        }

        $user = Auth::user();
        $user->fcm_token = $request->fcm_token;
        $user->save();

        $data["status"] = true;
        return response()->json($data, 200);

    }

    public function userInformation()
    {
        $user = Auth::user();
        $data["user"] = $user;
//        $data["user"] = call_user_func(array("App\\Http\\Resources\\UserResource", 'collection'), $user);
        return response()->json($data,200);
    }

    public function userUpdate(Request $request)
    {
        $user = Auth::user();
        if ($request->has("first_name")) {
            $user->first_name = $request->first_name;
        }

        if ($request->has("last_name")) {
            $user->last_name = $request->last_name;
        }

        if ($request->has("image")) {
            $user->image = $request->image;
        }

        if ($request->has("mobile")) {
            $user->mobile = $request->mobile;
        }

        if ($request->has("lang")) {
            $user->lang = $request->lang;
        }

        $user->save();


        $data["user"] = $user;
        $data["status"] = true;

        return response($data, 200);
    }

    public  function storeImage(Request $request)
    {
        if ($request->que)
            $imageName = "";
        $image = $request->input('image');  // your base64 encoded
        $image = str_replace('data:image/png;base64,', '', $image);
        $image = str_replace(' ', '+', $image);
        $imageName = Str::random(10).'.'.'png';
        Storage::disk('public')->put( $imageName, base64_decode($image));

        return $imageName;
    }
}
