<?php

namespace App\Http\Controllers;

use App\Freight;
use App\Http\Requests\StoreFreight;
use App\Http\Requests\StoreOption;
use App\Language;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class FreightController extends CrudController
{
    public function __construct(Freight $freight)
    {
        $this->model = $freight;
        $this->route = "freights";
        $this->title = "freights";

        $this->table_attributes = [
          "type_of_freight" => "text"
        ];

        $this->attributes = [
            "type_of_freight" => "translatable_text"
        ];

        $this->storeRequest = new StoreFreight();
        $this->updateRequest = new StoreFreight();

        parent::__construct();
    }

    public function store(Request $request)
    {
        $storeRequest = new StoreFreight();
        $this->validate($request,$storeRequest->rules());

        try {
            $item = $this->model;

            if (isset($this->model->translatable)) {
                $item->fill($request->except($this->model->translatable));

                foreach ($this->model->translatable as $attr) {
                    $trans = [];
                    foreach (Language::all() as $language) {
                        $var = $attr . "_" . $language->code;
                        $trans[$language->code] = $request->$var;
                    }
                    $item->$attr = $trans;
                }
            } else {
                $item->fill($request->all());
            }


            $item->save();

            Session::flash('message', trans('app.success message', ['action' => trans('app.create')]));
            Session::flash('class', 'success');

            return redirect()->route($this->route . '.show', $item->id);

        } catch
        (\League\Flysystem\Exception $e) {
            Session::flash('message', trans('app.error message', ['action' => trans('app.create')]));
            Session::flash('class', 'danger');

            return redirect()->back();
        }
    }
}
