<?php

namespace App\Http\Controllers\Front;

use App\Address;
use App\Brand;
use App\Category;
use App\Contact;
use App\Http\Controllers\Controller;
use App\Product;
use App\Social;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //  $this->middleware('guest')->except('logout');
    }

    public function showLoginForm()
    {
        $data = getLayoutData();

        if (Auth::user()) {
            $role = Auth::user()->role;
            if ($role == "admin" || $role == "entry")
                return redirect()->route('home');
            else
                return redirect()->route('front.home');
        } else {
            //TODO fetch layout data
            return view('auth.front.login')->with($data);
        }
    }

    protected function sendFailedLoginResponse(Request $request)
    {
        session()->put('message', trans('auth.failed'));
        session()->put('class', 'danger');

        throw ValidationException::withMessages([
            $this->username() => [trans('auth.failed')],
        ]);

    }

    public function authenticated(Request $request, $user)
    {
        if ($user->role == "admin" || $user->role == "entry")
            $this->redirectTo = "/admin/home";
        else
            $this->redirectTo = "/home";
    }
}
