<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreAssignOrder;
use App\Http\Requests\StoreDeliveryOrder;
use App\Http\Requests\StoreFinishedOrder;
use App\Http\Requests\StoreOrder;
use App\Notifications\ConfirmNotification;
use App\Notifications\FinishOrderNotification;
use App\Notifications\RejectOrderNotification;
use App\Order;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class OrderController extends CrudController
{
    public function __construct(Order $order)
    {
        $this->model = $order;
        $this->route = "orders";
        $this->title = "orders";

        if (request()->has("status")) {
            switch (request("status")) {
                case "pending" :
                    $this->title = "pending";
                    break;
                case "under_confirmation" :
                    $this->title = "under_confirmation";
                    break;
                case "delivery" :
                    $this->title = "delivery";
                    break;
                case "finished" :
                    $this->title = "finished";
                    break;
                case "rejected" :
                    $this->title = "rejected";
                    break;
            }

        }

        if (request()->has("status")) {
            switch (request('status')) {
                case "pending" :
                    $this->table_attributes = [
                        "from" => "text",
                        "to" => "text",
                        "type" => "text",
                        "type_of_payment" => "text",
                        "package_content" => "text",
                        "number_of_packages" => "text",
                        "status" => "text",
                        "is_breakable" => "options",
                    ];

                    $this->attributes = [
                        "from" => "text",
                        "to" => "text",
                        "type" => "options",
                        "type_of_payment" => "options",
                        "package_content" => "text",
                        "number_of_packages" => "text",
                        "is_breakable" => "options",
                        "height" => "text",
                        "length" => "text",
                        "weight" => "text",
                        "width" => "text",
                        "size" => "text",
                        "name" => "text",
                        "mobile" => "text",
                    ];

                    $this->storeRequest = new StoreDeliveryOrder();
                    $this->updateRequest = new StoreDeliveryOrder();

                    $this->actions = [
                        "approve",
                        "rejected"
                    ];

                    break;
                case "delivery":
                    $this->table_attributes = [
                        "from" => "text",
                        "to" => "text",
                        "type" => "text",
                        "type_of_payment" => "text",
                        "is_breakable" => "options",
                        "status" => "text",
                    ];

                    $this->attributes = [
                        "from" => "text",
                        "to" => "text",
                        "type" => "options",
                        "type_of_payment" => "options",
                        "is_breakable" => "options",
                        "height" => "text",
                        "length" => "text",
                        "weight" => "text",
                        "width" => "text",
                        "size" => "text",
                        "name" => "text",
                        "mobile" => "text",
                    ];

                    $this->storeRequest = new StoreFinishedOrder();
                    $this->updateRequest = new StoreFinishedOrder();
                    $this->actions = [
                        "finished"
                    ];
                    break;
                case "under_confirmation" :
                    $this->table_attributes = [
                        "from" => "text",
                        "to" => "text",
                        "type" => "text",
                        "type_of_payment" => "text",
                        "package_content" => "text",
                        "number_of_packages" => "text",
                        "is_breakable" => "options",
                        "status" => "text",
                    ];

                    $this->attributes = [
                        "from" => "text",
                        "to" => "text",
                        "type" => "options",
                        "type_of_payment" => "options",
                        "is_breakable" => "options",
                        "package_content" => "text",
                        "number_of_packages" => "text",
                        "height" => "text",
                        "length" => "text",
                        "weight" => "text",
                        "width" => "text",
                        "size" => "text",
                        "name" => "text",
                        "mobile" => "text",
                    ];

                    $this->storeRequest = new StoreOrder();
                    $this->updateRequest = new StoreOrder();
                    break;
                case "finished":
                    $this->table_attributes = [
                        "from" => "text",
                        "to" => "text",
                        "type" => "text",
                        "type_of_payment" => "text",
                        "package_content" => "text",
                        "number_of_packages" => "text",
                        "is_breakable" => "options",
                        "status" => "text",
                    ];

                    $this->attributes = [
                        "from" => "text",
                        "to" => "text",
                        "type" => "options",
                        "type_of_payment" => "options",
                        "package_content" => "text",
                        "number_of_packages" => "text",
                        "is_breakable" => "options",
                        "height" => "text",
                        "length" => "text",
                        "weight" => "text",
                        "width" => "text",
                        "size" => "text",
                        "rating" => "text",
                        "name" => "text",
                        "mobile" => "text",
                    ];

                    $this->storeRequest = new StoreOrder();
                    $this->updateRequest = new StoreOrder();

                    break;
                case "rejected":
                    $this->table_attributes = [
                        "from" => "text",
                        "to" => "text",
                        "type" => "text",
                        "type_of_payment" => "text",
                        "is_breakable" => "options",

                        "status" => "text",
                    ];

                    $this->attributes = [
                        "from" => "text",
                        "to" => "text",
                        "type" => "options",
                        "type_of_payment" => "options",
                        "package_content" => "text",
                        "number_of_packages" => "text",
                        "is_breakable" => "options",
                        "height" => "text",
                        "length" => "text",
                        "weight" => "text",
                        "width" => "text",
                        "size" => "text",
                        "name" => "text",
                        "mobile" => "text",
                    ];

                    $this->storeRequest = new StoreOrder();
                    $this->updateRequest = new StoreOrder();
                    break;
            }
        }

        $this->table_attributes = [
            "from" => "text",
            "to" => "text",
            "type" => "text",
            "type_of_payment" => "text",
            "status" => "text",
            "is_breakable" => "options",
            "package_content" => "text",
            "number_of_packages" => "text",
            "rating"=>"text"
        ];

        $this->attributes = [
            "from" => "text",
            "to" => "text",
            "type" => "options",
            "type_of_payment" => "options",
            "package_content" => "text",
            "number_of_packages" => "text",
            "status"=> "options",
            "is_breakable" => "options",
            "height" => "text",
            "length" => "text",
            "weight" => "text",
            "width" => "text",
            "size" => "text",
            "name" => "text",
            "mobile" => "text",
        ];

        $this->storeRequest = new StoreDeliveryOrder();
        $this->updateRequest = new StoreDeliveryOrder();

        parent::__construct();
    }

    public function approve($id, Request $request)
    {

        $validator = Validator::make($request->all(), [
            "cost" => "required",
            "driver_id" => "required",
        ]);

        if ($validator->fails()) {
            Session::flash('message', trans('app.error message', ['action' => trans('app.create')]));
            Session::flash('class', 'danger');
            return redirect()->back();

        }

        $order = Order::find($id);
        $order->status = "under_confirmation";
        $order->cost = $request->cost;
        $order->driver_id = $request->driver_id;
        $order->received_date = $request->received_date;
        $order->save();

        $order->user->notify(new ConfirmNotification($order));

        Session::flash('message', trans('app.success message', ['action' => trans('app.update')]));
        Session::flash('class', 'success');

        return redirect()->back();
    }

    public function rejected($id)
    {
        $order = Order::find($id);

        $order->status = "rejected";
        $order->save();

        $order->user->notify(new RejectOrderNotification($order));

        Session::flash('message', trans('app.success message', ['action' => trans('app.update')]));
        Session::flash('class', 'success');
        return redirect()->back();
    }

    public function orderDone($id)
    {
        $order = Order::find($id);
        $order->status = "finished";
        $order->save();

        $type = "order_arrival";
        $title_en = "Order Done";
        $title_ar = " توصيل الطلب";
        $body_en = "The Order has been done successfully";
        $body_ar = "تم توصيل الطلب بنجاح";

        $notification = storeNotification(\request(), $order->user,$order, $type, $title_en, $title_ar, $body_en, $body_ar);

        $order->user->notify(new FinishOrderNotification($notification, $order));

        $driver = $order->driver;
        $driver->balance += $order->cost;
        $driver->save();

        return redirect()->back();
    }


}
