<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreDeliveryOrder extends FormRequest
{
    public function rules()
    {
        return [
            'type' => 'required',
            'from' => 'required',
            'to' => 'required',
            'type_of_payment' => 'required',
            'mobile' => 'required|integer',
            'name' => 'required',
            'is_breakable' => 'required',
            'status' => 'required',
            "package_content" => "required",
            "number_of_packages" => "required",
        ];
    }

    public function messages()
    {
        return [
            'type.required'=>trans('validation.required'),
            'from.required'=>trans('validation.required'),
            'to.required'=>trans('validation.required'),
            'type_of_payment.required'=>trans('validation.required'),
            'name.required'=>trans('validation.required'),
            'mobile.required'=>trans('validation.required'),
            'mobile.integer'=>trans('validation.required'),
            'is_breakable.required'=>trans('validation.required'),
            'status.required'=>trans('validation.required'),
            'package_content.required'=>trans('validation.required'),
            'number_of_packages.required'=>trans('validation.required'),

        ] ;
    }

}
