<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreOrder extends FormRequest
{
    public function rules()
    {
        return [
            'type' => 'required',
            'from' => 'required',
            'to' => 'required',
            'type_of_payment' => 'required',
            'name' => 'required',
            'mobile' => 'required|integer',
            'number_of_packages' => 'required|integer',
            'package_content' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'type.required'=>trans('validation.required'),
            'from.required'=>trans('validation.required'),
            'to.required'=>trans('validation.required'),
            'type_of_payment.required'=>trans('validation.required'),
            'name.required'=>trans('validation.required'),
            'mobile.required'=>trans('validation.required'),
            'mobile.integer'=>trans('validation.required'),
            'number_of_packages.integer'=>trans('validation.integer'),
            'number_of_packages.required'=>trans('validation.required'),

        ] ;
    }
}
