<?php

namespace App\Http\Requests;

use App\Language;
use Illuminate\Foundation\Http\FormRequest;

class StoreUserNotification extends FormRequest
{
    public function rules()
    {
        $rules = [
            "user_id"=>"required"
        ];
        foreach (Language::all() as $language) {
            $attr = "title_" . $language->code;
            $rules[$attr] = 'required';
            $attr = "body_" . $language->code;
            $rules[$attr] = 'required';
        }

        return $rules;
    }

    public function messages()
    {
        return [
            "user_id.required" => trans("validation.required"),
        ];
    }
}
