<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $fillable = [
        "driver_id", "client_id", "type","from", "to", "type_of_payment",
         "name", "mobile", "status", "rating", "cost", "discreption",
        "is_breakable", "height", "length", "width", "weight", "size",
        "received_date", "number_of_packages", "package_content"
    ];

    public function user()
    {
        return $this->belongsTo(User::class, "client_id");
    }

    public function driver()
    {
        return $this->belongsTo(User::class, "driver_id");
    }

    public function states()
    {
        return $this->hasMany(State::class, "order_id");
    }

    public function ratings()
    {
        return $this->hasMany(Rating::class, "order_id");
    }
}
