<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class State extends Model
{
    use HasTranslations;

    protected $fillable = ["id", "user_id", "order_id", "status", "details", "title"];

    public $translatable = ["details", "title"];

    public function user()
    {
        return $this->belongsTo(User::class, "user_id");
    }

    public function order()
    {
        return $this->belongsTo(Order::class, "order_id");
    }


}
