<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('client_id')->references("id")->on("users")->onDelete("cascade");
            $table->unsignedBigInteger('driver_id')->references("id")->on("users")->onDelete("cascade");
            $table->string("type");
            $table->string("from");
            $table->string("to");
            $table->string("type_of_payment");
            $table->boolean("is_breakable");
            $table->integer("height")->nullable();
            $table->integer("length")->nullable();
            $table->integer("width")->nullable();
            $table->integer("weight")->nullable();
            $table->integer("size")->nullable();
            $table->string("status");
            $table->string("name");
            $table->string("mobile");
            $table->string("rating")->nullable();
            $table->integer("cost")->nullable();
            $table->string("received_date")->nullable();
            $table->string("discreption")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
