@extends('layouts.front')

@section('content')

    <section id="register" class="add-project pos-relative pt-5 register grey3-bg">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 offset-lg-1 col-12 add-form">
                    <form method="POST" action="{{ route('register') }}"
                          class="row mr-0 ml-0 w-100 shadow radius-30 white-bg wrap">

                        <input type="hidden" name="type" value="{{request('type')}}">
                        @csrf
                        <div class="col-12 mb-4">
                            <div class="d-block w-100 form-logo">
                                <img src="{{asset('front/imgs/logo.png')}}"
                                     style="width: 250px"/></div>
                        </div>
                        <div class="col-12 mb-2">
                            <span class="f-big main-text f-bold">{{trans('front.create account')}}</span>
                        </div>
                        <div class="col-12 pb-3 mb-4 def-border-bottom">
                            <span class="f-extramedium f-med">{{trans('front.tell us')}}</span>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group mb-4">
                                <label class="label">
                                    {{trans('front.first name')}} <span class="main-text">*</span>
                                </label>
                                <input value="{{old('first_name')}}" required name="first_name" type="text"
                                       class="form-control{{ $errors->has('first_name') ? ' is-invalid' : '' }}">
                                @if ($errors->has('first_name'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('first_name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group mb-4">
                                <label class="label">
                                    {{trans('front.last name')}} <span class="main-text">*</span>
                                </label>
                                <input value="{{old('last_name')}}" required name="last_name" type="text"
                                       class="form-control{{ $errors->has('last_name') ? ' is-invalid' : '' }}">
                                @if ($errors->has('last_name'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('last_name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-12 col-12">
                            <div class="form-group mb-4">
                                <label class="label">
                                    {{trans('front.country')}} <span class="main-text">*</span>
                                </label>
                                <select required name="country"
                                        class="form-control{{ $errors->has('country') ? ' is-invalid' : '' }} mb-lg-0 select-2">
                                    <option>{{trans('front.choose country')}}</option>
                                    @foreach($countries as $country)
                                        <option
                                            {{old('country') == $country->code ? 'selected' : ''}} value="{{$country->code}}">{{$country->text}}</option>
                                    @endforeach
                                </select>
                                @if ($errors->has('country'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('country') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-12  pb-3 mb-4 def-border-bottom mt-3">
                            <span class="f-extramedium f-med">{{trans('front.your details')}}</span>
                        </div>

                        <div class="col-lg-12 col-12">
                            <div class="form-group mb-4">
                                <label class="label">
                                    {{trans('front.email')}} <span class="main-text">*</span>
                                </label>
                                <input required name="email" type="email" value="{{old('email')}}"
                                       class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}">
                                @if ($errors->has('email'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group mb-4">
                                <label class="label">
                                    {{trans('front.password')}} <span class="main-text">*</span>
                                </label>
                                <input required name="password" type="password"
                                       class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}">
                                @if ($errors->has('password'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group mb-4">
                                <label class="label">
                                    {{trans('front.confirm password')}}<span class="main-text">*</span>
                                </label>
                                <input required name="password_confirmation" type="password" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-12 col-12">
                            <div class="form-group mb-4">
                                <label class="mouse">
                                    <span class="mr-2"><input name="agree" required type="checkbox"
                                                              class="aa-check-select"/></span>
                                    <span class="pt-1">{{trans('front.i agree')}}
                                    <a target="_blank" href="{{route('front.terms')}}"
                                       class="main-text">{{trans('front.terms of use')}}</a>
                                    {{trans('front.and the')}}
                                    <a target="_blank" href="{{route('front.privacy')}}"
                                       class="main-text">{{trans('front.privacy policy')}}</a>
                                    .</span>
                                </label>
                            </div>
                        </div>

                        <div class="col-12">
                            <button type="submit" class="butn main-butn f-medium next">
                                <span>{{trans('front.create')}}</span>
                            </button>
                        </div>
                        <div class="col-12">
                            <a href="{{route('login')}}" class="d-inline-block main-text f-normal mt-3"
                               data-toggle="tooltip"
                               title="Login now!">{{trans('front.already have account')}}</a>
                        </div>

                    </form>
                </div>
                <div class="col-lg-5 col-12">
                    <div class="w-100 h-100 img">
                        <img src="{{asset('front/imgs/icons/register.png')}}" class="w-100"/>
                    </div>
                </div>
            </div>
        </div>
    </section>

@overwrite
