@extends('layouts.app')

@section('navbar')
    @include('partials.navbar')
@overwrite

@section('sidebar')
    @include('sidebar.index')
@overwrite

@section('content')
    <div class="content-wrapper">
        <div class="content">
            <div class="row">
                @for($i = 0 ; $i < count($statistics) ; $i++)
                    @if($i % 2 == 0)
                        <div class="col-sm-6 col-xl-3">
                            <div class="card card-body">
                                <a href="{{$statistics[$i]["route"]}}">
                                    <div class="media">
                                        <div class="mr-3 align-self-center">
                                            <i class="icon-{{$statistics[$i]["icon"]}} icon-3x {{$statistics[$i]["color"]}}"></i>
                                        </div>

                                        <div class="media-body text-right">
                                            <h3 class="font-weight-semibold mb-0">{{$statistics[$i]["count"]}}</h3>
                                            <span
                                                class="text-uppercase font-size-sm text-muted">{{trans('statistics.'.$statistics[$i]["title"])}}</span>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    @else
                        <div class="col-sm-6 col-xl-3">
                            <div class="card card-body">
                                <a href="{{$statistics[$i]["route"]}}">
                                    <div class="media">
                                        <div class="mr-3 align-self-center">
                                            <i class="icon-{{$statistics[$i]["icon"]}} icon-3x {{$statistics[$i]["color"]}}"></i>
                                        </div>

                                        <div class="media-body text-right">
                                            <h3 class="font-weight-semibold mb-0">{{$statistics[$i]["count"]}}</h3>
                                            <span
                                                class="text-uppercase font-size-sm text-muted">{{trans('statistics.'.$statistics[$i]["title"])}}</span>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    @endif
                @endfor
            </div>
        </div>
    </div>
@overwrite

