@php(!isset($array) ? $array = false : false)
@php(!isset($name) ? $name = '' : false)
<div class="form-group form-group-feedback form-group-feedback-right">
    <input id="path-holder_{{$attribute}}" class="form-control {{$array == false && $errors->has($attribute) ? ' border-danger' : '' }}
            form-control-lg" type="text" name="{{$name}}{{$attribute}}{{$array ? '[]' : ''}}" placeholder="{{trans('app.click to upload image')}}"
           value="{{$array == false ? (isset($item) ? $item->$attribute : old($attribute) ) : ''}}" readonly>
    <div id="path-icon-div_{{$attribute}}" class="form-control-feedback form-control-feedback-lg">
        <a href="#" class="list-icons-item btn-upload" data-toggle="modal" data-trigger="hover"
           data-target="#upload-image-modal_{{$attribute}}"><i class="icon-upload icon-2x"></i></a>
    </div>
</div>
@if($array == false && $errors->has($attribute))
    <span class="form-text text-danger">
    <strong>{{ $errors->first($attribute) }}</strong>
</span>
@endif

<!-- Iconified modal -->
<div id="upload-image-modal_{{$attribute}}" class="modal fade" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="icon-upload mr-2"></i> &nbsp;{{trans('app.upload')}}</h5>
                <button  type="button" class="close" data-dismiss="modal">&times;</button>
            </div>

            <div class="modal-body">
                <input type="file" id="image-input_{{$attribute}}" data-fouc>
            </div>
        </div>
    </div>
</div>
<!-- /iconified modal -->


@push('script')
    <script src="{{asset('global_assets/js/plugins/uploaders/fileinput/fileinput.min.js')}}"></script>
    <script src="{{asset('global_assets/js/demo_pages/uploader_bootstrap.js')}}"></script>
    <script>
        let image_input_{{$attribute}} = $('#image-input_{{$attribute}}');
        image_input_{{$attribute}}.fileinput({
            browseLabel: '{{trans('app.choose file')}}',
            uploadLabel: '{{trans('app.upload')}}',
            removeLabel: '{{trans('app.delete')}}',
            dropZoneTitle: '{{trans('app.drop')}}',
            uploadUrl: '{{route('files.single')}}',
            uploadAsync: false,
            maxFileCount: 1,
            initialPreview: [],
            browseIcon: '<i class="icon-file-plus mr-2"></i>',
            uploadIcon: '<i class="icon-file-upload2 mr-2"></i>',
            removeIcon: '<i class="icon-cross2 font-size-base mr-2"></i>',
            fileActionSettings: {
                zoomIcon: '<i class="icon-zoomin3"></i>',
                zoomClass: '',
                indicatorSuccess: '<i class="icon-checkmark3 file-icon-large text-success"></i>',
                indicatorError: '<i class="icon-cross2 text-danger"></i>',
                indicatorLoading: '<i class="icon-spinner2 spinner text-muted"></i>',
            },
            layoutTemplates: {
                icon: '<i class="icon-file-check"></i>',
                modal: modalTemplate
            },
            initialCaption: '{{trans('app.No file selected')}}',
            previewZoomButtonClasses: previewZoomButtonClasses,
            previewZoomButtonIcons: previewZoomButtonIcons,
            uploadExtraData: {
                model: '{{$route}}'
            }
        });
        image_input_{{$attribute}}.on('filebatchuploadsuccess', function (event, data, previewId, index) {
            let response_{{$attribute}} = data.response;
            let path_{{$attribute}} = response_{{$attribute}}.path;
            $("#path-holder_{{$attribute}}").val(path_{{$attribute}});
            $('#path-icon-div_{{$attribute}}').html('<i class="icon-file-check"></i>');
            setTimeout(function () {
                $('#image-input_{{$attribute}}').fileinput('clear');
                $('#upload-image-modal_{{$attribute}}').modal('hide');
            }, 1000);
        });
    </script>
@endpush
