<!-- Iconified modal -->
<div id="view-file-modal" class="modal fade" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="icon-eye mr-2"></i> &nbsp;{{trans('app.view')}}</h5>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>

            <div class="modal-body img-responsive">
                <video autoplay id="video-canvas" style="display: none ;" height="240" controls width="100%"></video>
                <img style="display: none ;" class="text-center" src="" id="image-canvas" width="100%">
            </div>
        </div>
    </div>
</div>
<!-- /iconified modal -->

@push('script')
    <script>
        $(document).on('click', '.btn-view', function () {
            let icanvas = $("#image-canvas");
            let vcanvas = $("#video-canvas");
            let source = $("<source>");
            let path = $(this).data('path');
            let src = '{{asset("storage/")}}' + '/' + path;
            if (path.toLowerCase().match(/\.(mp4)/g)) {
                source.attr("src", src);
                source.attr("type", "video/mp4");
                vcanvas.append(source);
                vcanvas.show();
                vcanvas.get(0).play();
            } else {
                icanvas.attr('src', src);
                icanvas.show();
            }
        });
    </script>
@endpush