@extends('layouts.app')

@section('navbar')
    @include('partials.navbar')
@overwrite

@section('sidebar')
    @include('sidebar.index')
@overwrite

@section('content')
    <div class="content">
        <div class="card">
            <div class="card-header bg-info border-bottom-0">
                <i class="fa fa-search"></i>
                <span>بحث و فرز</span>
            </div>
            <div class="card-body">
                {{ Form::open(['method' => "get", "id" => "courses-form"]) }}
                {{ Form::token() }}

                <div class="row">

                    <div class="col-md-6">
                        <div class="form-group row align-items-center">
                            <label for="from_date" class="col-md-2 text-left">من تاريخ</label>
                            <div class="col-md-10">
                                {{ Form::date('from_date', old("from_date", $model->from_date), ['class' => 'form-control', 'id' => 'from_date']) }}
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group row align-items-center">
                            <label for="to_date" class="col-md-2 text-left">الى تاريخ</label>
                            <div class="col-md-10">
                                {{ Form::date('to_date', old("to_date", $model->to_date), ['class' => 'form-control', 'id' => 'to_date']) }}
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group row align-items-center">
                            <label for="city_id" class="col-md-2 text-left">التصنيف :</label>
                            <div class="col-md-10">
                                {{ Form::select('category_id', ['0'=>null]+$categories,$model->category_id, ['class' => 'form-control ', 'id' => 'category_id']) }}
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group row align-items-center">
                            <label for="city_id" class="col-md-2 text-left">الدورة التدريبية :</label>
                            <div class="col-md-10">
                                {{ Form::select('course_id', ['0'=>null]+$courses,$model->course_id, ['class' => 'form-control ', 'id' => 'course_id']) }}
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group row align-items-center">
                            <label for="city_id" class="col-md-2 text-left">المدرب :</label>
                            <div class="col-md-10">
                                {{ Form::select('user_id', ['0'=>null]+$trainers,$model->user_id, ['class' => 'form-control ', 'id' => 'user_id']) }}
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group row align-items-center">
                            <label for="city_id" class="col-md-2 text-left">الطالب :</label>
                            <div class="col-md-10">
                                {{ Form::select('student_id', ['0'=>null]+$students,$model->student_id, ['class' => 'form-control ', 'id' => 'student_id']) }}
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group row align-items-center">
                            <label for="city_id" class="col-md-2 text-left">طريقة الدفع :</label>
                            <div class="col-md-10">
                                {{ Form::select('payment_method', ['0'=>null]+$payments,$model->payment_method, ['class' => 'form-control ', 'id' => 'payment_method']) }}
                            </div>
                        </div>
                    </div>

                </div>
                <div class="d-flex justify-content-between">
                    <div>
                    </div>
                    <div>
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-filter"></i>
                            <span>فرز النتائج</span>
                        </button>
                        <a href="{{route('statistics' , "finance")}}" class="btn btn-danger">
                            <i class="fa fa-ban"></i>
                            <span>اعادة تعيين</span>
                        </a>
                    </div>
                </div>
                {{ Form::close() }}
            </div>
        </div>


        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    @if($items->count() > 0)
                        <table class="table table-bordered datatable-basic" lang="ar" dir="rtl">
                            <thead class="bg-primary">
                            <tr>
                                <th>الدورة التدريبية</th>
                                <th>التصنيف</th>
                                <th>المدرب</th>
                                <th>الطالب</th>
                                <th>تاريخ الانضمام</th>
                                <th>طريقة الدفع</th>
                                <th>التكلفة</th>
                                <th>حصة الموقع</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $item)
                                <tr>
                                    <td>{{$item->course->title}}</td>
                                    <td>{{$item->course->category->name}}</td>
                                    <td>{{$item->course->user->name}}</td>
                                    <td>{{$item->user->name}}</td>
                                    <td>{{$item->created_at->format('Y-m-d')}}</td>
                                    <td>{{getOption("payment_methods" , $item->payment_method)}}</td>
                                    <td>{{$item->course->price}} {{trans('front.ils')}}</td>
                                    <td>{{$item->course->price / 10}} {{trans('front.ils')}}</td>
                                </tr>
                            @endforeach
                            </tbody>
                            <tfoot>
                            <tr class="bg-primary">
                                <td colspan="6">المجموع</td>
                                <td><b>{{$all_total}}</b> {{trans('front.ils')}}</td>
                                <td><b>{{$website_total}}</b> {{trans('front.ils')}}</td>
                            </tr>
                            </tfoot>
                        </table>
                    @else
                        <div class="alert alert-info alert-styled-left">
                            <i class="fa fa-info-circle"></i>{!! trans('app.no items message') !!}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @include('modals.delete-modal')
@overwrite

@section('style')
    <style href="{{asset('global_assets/js/plugins/tables/datatables/dataTables.bootstrap4.min.css')}}"></style>
    <style
        href="{{asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.bootstrap4.min.css')}}"></style>
@overwrite

@section('script')
    <script src="{{asset('global_assets/js/plugins/tables/datatables/datatables.min.js')}}"></script>
    <script src="{{asset('global_assets/js/plugins/tables/datatables/dataTables.bootstrap4.min.js')}}"></script>
    <script
        src="{{asset('global_assets/js/plugins/tables/datatables/extensions/buttons/dataTables.buttons.min.js')}}"></script>
    <script
        src="{{asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.bootstrap4.min.js')}}"></script>
    <script src="{{asset('global_assets/js/plugins/tables/datatables/extensions/jszip/jszip.min.js')}}"></script>
    <script src="{{asset('global_assets/js/plugins/tables/datatables/extensions/pdfmake/pdfmake.min.js')}}"></script>
    <script src="{{asset('global_assets/js/plugins/tables/datatables/extensions/pdfmake/vfs_fonts.min.js')}}"></script>
    <script
        src="{{asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.html5.min.js')}}"></script>
    <script
        src="{{asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.print.min.js')}}"></script>
    <script
        src="{{asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.colVis.min.js')}}"></script>

    <script>

        let table = $('.datatable-basic').DataTable({
            "pageLength": 5,
            dom: 'Bfrtip',
            "aaSorting": [[2, 'desc']],
            buttons: [
                {
                    extend: 'excel',
                    text: '  <i class="icon-file-excel"></i>  إكسل',
                    className: '',
                    header: true
                }
            ],
            pagingType: "numbers",
            language: {
                search: '<span>البحث:</span> _INPUT_',
                info: '',

                searchPlaceholder: 'بحث',
                lengthMenu: '<span>عرض:</span> _MENU_',
            }
        });
    </script>
@overwrite
