@extends('layouts.app')

@section('navbar')
    @include('partials.navbar')
@overwrite

@section('sidebar')
    @include('sidebar.index')
@overwrite

@section('content')

    <div class="content">
        <h1>تقرير الشحنات حسب الحالة</h1>
        <div class="card">
            <div class="card-header bg-info border-bottom-0">
                <i class="fa fa-search"></i>
                <span>بحث و فرز</span>
            </div>
            <div class="card-body">
                {{ Form::open(['method' => "get", "id" => "orders-form"]) }}
                {{ Form::token() }}

                <div class="row">

                    <div class="col-md-6">
                        <div class="form-group row align-items-center">
                            <label for="from_date" class="col-md-2 text-left">من تاريخ</label>
                            <div class="col-md-10">
                                {{ Form::date('from_date', old("from_date", $model->from_date), ['class' => 'form-control', 'id' => 'from_date']) }}
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group row align-items-center">
                            <label for="to_date" class="col-md-2 text-left">إلى تاريخ </label>
                            <div class="col-md-10">
                                {{ Form::date('to_date', old("to_date", $model->to_date), ['class' => 'form-control', 'id' => 'to_date']) }}
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group row align-items-center">
                            <label for="city_id" class="col-md-2 text-left"> حالة الشحنة :</label>
                            <div class="col-md-10">
                                {{ Form::select('status', ['0'=>'الكل']+$status,$model->status, ['class' => 'form-control ', 'id' => 'status']) }}
                            </div>
                        </div>
                    </div>



                </div>
                <div class="d-flex justify-content-between">
                    <div>
                    </div>
                    <div>
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-filter"></i>
                            <span>فرز النتائج</span>
                        </button>
                        <a href="{{route('statistics' , "ordersTypes")}}" class="btn btn-danger">
                            <i class="fa fa-ban"></i>
                            <span>اعادة تعيين</span>
                        </a>
                    </div>
                </div>
                {{ Form::close() }}
            </div>
        </div>


        <div class="card">


            <div class="card-body">


                <div class="table-responsive">
                    @if($items->count() > 0)
                        <table class="table table-bordered datatable-basic" lang="ar" dir="rtl">
                            <thead class="bg-primary">
                            <tr>
                                <th>نوع الشحنة</th>
                                <th>رقم المستخدم</th>
                                <th>حالة الشحنة</th>
                                <th>التاريخ</th>
                                <th>التكلفة</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $item)
                                <tr>
                                    <td>{{($item->type)}}</td>
                                    <td>{{optional($item->user)->mobile}}</td>
                                    <td>{{trans("app.".$item->status)}}</td>
                                    <td>{{$item->created_at->format('Y-m-d')}}</td>
                                    <td>{{$item->cost}} {{trans('app.sy')}}</td>
                                </tr>
                            @endforeach
                            </tbody>
                            <tfoot>
                            <tr class="bg-primary">
                                <td colspan="4">المجموع</td>
                                <td><b>{{$total}}</b> {{trans('app.sy')}}</td>
                            </tr>
                            </tfoot>
                        </table>
                    @else
                        <div class="alert alert-info alert-styled-left">
                            <i class="fa fa-info-circle"></i>{!! trans('app.no items message') !!}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @include('modals.delete-modal')
@overwrite

@section('style')
    <style href="{{asset('global_assets/js/plugins/tables/datatables/dataTables.bootstrap4.min.css')}}"></style>
    <style
        href="{{asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.bootstrap4.min.css')}}"></style>
@overwrite

@section('script')
    <script src="{{asset('global_assets/js/plugins/tables/datatables/datatables.min.js')}}"></script>
    <script src="{{asset('global_assets/js/plugins/tables/datatables/dataTables.bootstrap4.min.js')}}"></script>
    <script
        src="{{asset('global_assets/js/plugins/tables/datatables/extensions/buttons/dataTables.buttons.min.js')}}"></script>
    <script
        src="{{asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.bootstrap4.min.js')}}"></script>
    <script src="{{asset('global_assets/js/plugins/tables/datatables/extensions/jszip/jszip.min.js')}}"></script>
    <script src="{{asset('global_assets/js/plugins/tables/datatables/extensions/pdfmake/pdfmake.min.js')}}"></script>
    <script src="{{asset('global_assets/js/plugins/tables/datatables/extensions/pdfmake/vfs_fonts.min.js')}}"></script>
    <script
        src="{{asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.html5.min.js')}}"></script>
    <script
        src="{{asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.print.min.js')}}"></script>
    <script
        src="{{asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.colVis.min.js')}}"></script>

    <script>

        let table = $('.datatable-basic').DataTable({
            "pageLength": 5,
            dom: 'Bfrtip',
            "aaSorting": [[2, 'desc']],
            buttons: [
                {
                    extend: 'excel',
                    text: '  <i class="icon-file-excel"></i>  إكسل',
                    className: '',
                    header: true
                }
            ],
            pagingType: "numbers",
            language: {
                search: '<span>البحث:</span> _INPUT_',
                info: '',

                searchPlaceholder: 'بحث',
                lengthMenu: '<span>عرض:</span> _MENU_',
            }
        });
    </script>
@overwrite
