<?php

use App\Trip;
use App\User;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

Route::get('storage/link', function () {
    \Illuminate\Support\Facades\Artisan::call('storage:link');
});


Route::group([
    'prefix' => LaravelLocalization::setLocale(),
    'middleware' => ['localize', 'localeSessionRedirect', 'localizationRedirect', 'localeViewPath']
], function () {

    Route::group(['prefix' => 'admin'], function () {
        Route::get('/', function () {
            return redirect('admin/login');
        });

        Route::get('/home', 'HomeController@home')->name('home');
        Route::get('/profile', 'HomeController@profile')->name('profile');
		Route::post('/reset-password' , 'HomeController@resetPassword')->name('reset-password');
        Route::get('/preferences', 'HomeController@preferences')->name('preferences');

        Route::post('files/single', 'FileController@single')->name('files.single');
        Route::post('files/multiple', 'FileController@multiple')->name('files.multiple');

        Route::get('login', 'Auth\LoginController@showLoginForm')->name('login');
        Route::post('login', 'Auth\LoginController@login');
        Route::post('logout', 'Auth\LoginController@logout')->name('logout');


        Route::get('/reports', 'ReportController@index')->name('reports.index');
        Route::get('users/{id}/showcar','UserController@showcar')->name('users.showcar');
        Route::get('users/{id}/block','UserController@block')->name('users.block');
        Route::get("/drivers", "UserController@drivers")->name("drivers");
        Route::get('/approve-modal', 'UserController@approve')->name('approve');

        Route::post('/orders/{id}/approved', 'OrderController@approve')->name('orders.approve');
        Route::post('/orders/{id}/rejected', 'OrderController@rejected')->name('orders.rejected');
        Route::post('/users/reset/{id}', 'UserController@resetBalance')->name('resetBalance');
        Route::post('/orders/status/{id}', 'OrderController@orderDone')->name('orderDone');

        Route::get('/statistics/{type}', 'StatisticController@report')->name('statistics');
        Route::get('notifications.broadcast', 'NotificationController@broadcast')->name('notifications.broadcast');

        //resources routes
        foreach (MODELS as $model) {
            Route::resource(getPlural($model), ucfirst($model) . 'Controller');
        }
    });

    //Front route
    Route::group([], function () {

        Route::get('/', 'FrontController@home')->name('front.index');

    });

});

