<!-- Search field -->
<div class="card">
    <div class="card-body">
        <form id="filter-form" method="get" action="<?php echo e(route($route.'.index')); ?>">
            <div class="input-group mb-3">
                <div class="form-group-feedback form-group-feedback-left">
                    <input name="query" type="text" class="form-control form-control-sm"
                           placeholder="<?php echo e(trans('app.search')); ?>" value="<?php echo e(request('query')); ?>">
                    <div class="form-control-feedback form-control-feedback-sm">
                        <i class="icon-search4 text-muted"></i>
                    </div>
                </div>
                <div class="input-group-append">
                    <button type="submit" class="btn btn-primary btn-sm btn-lg"><?php echo e(trans('app.go')); ?></button>
                </div>
            </div>
            <?php ($value_var = "text_".getLocale()); ?>
            <div class="d-md-flex align-items-md-center flex-md-wrap text-center text-md-left">
                <ul class="list-inline list-inline-condensed mb-0">
                    <?php $__currentLoopData = $filters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $filter => $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="list-inline-item dropdown" >
                            <a href="#" class="btn btn-link text-default dropdown-toggle"
                               data-toggle="dropdown" >
                                <i class="icon-stack2 mr-2"></i>
                                <?php if(request()->has($filter)): ?>
                                    <?php echo e(getItemData(request($filter) , $filter)); ?>

                                <?php else: ?>
                                    <?php echo e(trans('attributes.'.$filter)); ?>

                                <?php endif; ?>
                            </a>

                            <div class="dropdown-menu" style="height: 200px; overflow: auto">
                                <?php if($type == "select"): ?>
                                    <?php $__currentLoopData = getSelectItems($route , $filter); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e(route($route.'.index')."?".$filter.'='.$item->id . getRouteString(request()->except($filter))); ?>"
                                           class="dropdown-item <?php echo e(request($filter) == $item->id ? 'active' : ''); ?>">
                                            <?php echo e($filter == "client_id" ? $item->mobile :  $item->name); ?>

                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php elseif($type == "options"): ?>
                                    <?php $__currentLoopData = getSelectOptions($route , $filter); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e(route($route.'.index').'?'.$filter.'='.$item->code. getRouteString(request()->except($filter))); ?>"
                                           class="dropdown-item"><?php echo e($item->text); ?></a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <li class="list-inline-item">
                        <a href="<?php echo e(route($route.'.index')); ?>" class="btn btn-link text-default">
                            <i class="icon-reload-alt mr-2"></i><?php echo e(trans('app.reset')); ?>

                        </a>
                    </li>
                </ul>
            </div>
        </form>
    </div>
</div>
<!-- /search field -->
<?php /**PATH C:\Users\ASUS\Desktop\Eshhanli1\resources\views/partials/filters.blade.php ENDPATH**/ ?>