<?php namespace FarhanWazir\GoogleMaps;

use FarhanWazir\GoogleMaps\Containers\isInsidePolygon;
use Illuminate\Support\Facades\DB;

class GMaps
{

    protected $output_js;
    protected $output_js_contents;
    protected $output_html;
    protected $apiKey = '';

    public $adsense = false;                    // Whether Google Adsense For Content should be enabled
    public $adsenseChannelNumber = '';                        // The Adsense channel number for tracking the performance of this AdUnit
    public $adsenseFormat = 'HALF_BANNER';            // The format of the AdUnit
    public $adsensePosition = 'TOP_CENTER';                // The position of the AdUnit
    protected $adsensePublisherID = '';                        // Your Google AdSense publisher ID

    public $backgroundColor = '';                        // A hex color value shown as the map background when tiles have not yet loaded as the user pans
    public $bicyclingOverlay = false;                    // If set to TRUE will overlay bicycling information (ie. bike paths and suggested routes) onto the map by default
    public $center = '37.4419, -122.1419';        // Sets the default center location (lat/long co-ordinate or address) of the map. If defaulting to the users location set to "auto"
    public $class = '';                        // A class name if wishing to style the map further through CSS. Can also be useful if wanting it to be responsive etc.
    public $cluster = false;                    // Whether to cluster markers
    public $clusterGridSize = 60;                        // The grid size of a cluster in pixels
    public $clusterMaxZoom = '';                        // The maximum zoom level that a marker can be part of a cluster
    public $clusterZoomOnClick = true;                        // Whether the default behaviour of clicking on a cluster is to zoom into it
    public $clusterAverageCenter = false;                    // Whether the center of each cluster should be the average of all markers in the cluster
    public $clusterMinimumClusterSize = 2;                        // The minimum number of markers to be in a cluster before the markers are hidden and a count is shown
    public $clusterStyles = [];                 // (object) An array that has style properties: *  'url': (string) The image url. *  'height': (number) The image height. *  'width': (number) The image width. *  'anchor': (Array) The anchor position of the label text. *  'textColor': (string) The text color. *  'textSize': (number) The text size. *  'backgroundPosition': (string) The position of the backgound x, y.
    public $disableDefaultUI = false;                    // If set to TRUE will hide the default controls (ie. zoom, scale etc)
    public $disableDoubleClickZoom = false;                    // If set to TRUE will disable zooming when a double click occurs
    public $disableMapTypeControl = false;                    // If set to TRUE will hide the MapType control (ie. Map, Satellite, Hybrid, Terrain)
    public $disableNavigationControl = false;                    // If set to TRUE will hide the Navigation control (ie. zoom in/out, pan)
    public $disableScaleControl = false;                    // If set to TRUE will hide the Scale control
    public $disableStreetViewControl = false;                    // If set to TRUE will hide the Street View control
    public $enableFullScreenControl = false;                    // If set to TRUE will enable full screen control
    public $draggable = true;                        // If set to FALSE will prevent the map from being dragged around
    public $draggableCursor = '';                        // The name or url of the cursor to display on a draggable object
    public $draggingCursor = '';                        // The name or url of the cursor to display when an object is being dragged
    public $geocodeCaching = false;                    // If set to TRUE will cache any geocode requests made when an address is used instead of a lat/long. Requires DB table to be created (see documentation)
    public $geoCacheTableName = 'gmaps_geocache';   //Geo cache database table name
    public $https = false;                    // If set to TRUE will load the Google Maps JavaScript API over HTTPS, allowing you to utilize the API within your HTTPS secure application
    public $navigationControlPosition = '';                        // The position of the Navigation control, eg. 'BOTTOM_RIGHT'
    public $infowindowMaxWidth = 0;                        // The maximum width of the infowindow in pixels. Expecting an integer without units
    public $keyboardShortcuts = true;                        // If set to FALSE will disable to map being controlled via the keyboard
    public $jsfile = '';                        // Set this to the path of an external JS file if you wish the JavaScript to be placed in a file rather than output directly into the <head></head> section. The library will try to create the file if it does not exist already. Please ensure the destination file is writeable
    public $kmlLayerURL = '';                        // A URL to publicly available KML or GeoRSS data for displaying geographic information. Multiple KML layers can be passed in by using an array of URL's. Note, if using multiple you'll probably have to set $kmlLayerPreserveViewport to true and manually set map center and zoom
    public $kmlLayerPreserveViewport = false;                    // Specifies whether the map should be adjusted to the bounds of the KmlLayer's contents. By default the map is zoomed and positioned to show the entirety of the layer's contents
    public $language = '';                        // The map will by default load in the language of the browser. This can be overriden however here. For a full list of codes see https://spreadsheets.google.com/pub?key=p9pdwsai2hDMsLkXsoM05KQ&gid=1
    public $loadAsynchronously = false;                    // Load the map and API asynchronously once the page has loaded
    public $map_div_id = "map_canvas";                // The ID of the <div></div> that is output which contains the map
    public $map_height = "450px";                    // The height of the map container. Any units (ie 'px') can be used. If no units are provided 'px' will be presumed
    public $map_name = "map";                    // The JS reference to the map. Currently not used but to be used in the future when multiple maps are supported
    public $map_type = "ROADMAP";                // The default MapType. Values accepted are 'HYBRID', 'ROADMAP', 'SATELLITE' or 'TERRAIN'
    public $map_types_available = array();                    // The other MapTypes available for selection on the map
    public $map_width = "100%";                    // The width of the map container. Any units (ie 'px') can be used. If no units are provided 'px' will be presumed
    public $maps_loaded = 0;                        // Counter which keeps track of how many maps have been created to avoid standard functions being output twice
    public $mapTypeControlPosition = '';                        // The position of the MapType control, eg. 'BOTTOM_RIGHT'
    public $mapTypeControlStyle = '';                        // The style of the MapType control. blank, 'DROPDOWN_MENU' or 'HORIZONTAL_BAR' values accepted.
    public $minzoom = '';                        // The minimum zoom level which will be displayed on the map
    public $maxzoom = '';                        // The maximum zoom level which will be displayed on the map
    public $minifyJS = false;                    // If TRUE will run the JavaScript through Jsmin.php (this file and PHP5+ required) to minify the code
    public $noClear = false;                    // If TRUE do not clear the contents of the map div
    public $onboundschanged = '';                        // The JavaScript action to perform when the viewport bounds have changed
    public $oncenterchanged = '';                        // The JavaScript action to perform when themap center property changes
    public $onclick = '';                        // The JavaScript action to perform when the map is clicked
    public $ondblclick = '';                        // The JavaScript action to perform when the map is double-clicked
    public $ondrag = '';                        // The JavaScript action to perform while the map is dragged
    public $ondragend = '';                        // The JavaScript action to perform when the user stops dragging the map
    public $ondragstart = '';                        // The JavaScript action to perform when the user starts dragging the map
    public $onidle = '';                        // The JavaScript action to perform when the map becomes idle after panning or zooming
    public $onload = '';                        // The JavaScript action to perform when the map first loads. This library hi-jacks the window.load event so add any bespoke code using this option
    public $onstaged = '';
    public $onmousemove = '';                        // The JavaScript action to perform when the user's mouse moves over the map container
    public $onmouseout = '';                        // The JavaScript action to perform when the user's mouse exits the map container
    public $onmouseover = '';                        // The JavaScript action to perform when the user's mouse enters the map container
    public $onresize = '';                        // The JavaScript action to perform when the maps div changes size
    public $onrightclick = '';                        // The JavaScript action to perform when the map is right-clicked
    public $ontilesloaded = '';                        // The JavaScript action to perform when the visible tiles have finished loading
    public $onzoomchanged = '';                        // The JavaScript action to perform when the maps zoom property changes
    public $panoramio = false;                    // If TRUE will add photos from Panoramio as a layer to your maps as a series of large and small photo icons
    public $panoramioTag = '';                        // Restrict the set of Panoramio photos shown to those matching a certain textual tag
    public $panoramioUser = '';                        // Restrict the set of Panoramio photos shown to those matching a particular user
    public $region = '';                        // Country code top-level domain (eg "uk") within which to search. Useful if supplying addresses rather than lat/longs
    public $scaleControlPosition = '';                        // The position of the Scale control, eg. 'BOTTOM_RIGHT'
    public $scrollwheel = true;                        // If set to FALSE will disable zooming by scrolling of the mouse wheel
    protected $sensor = false;                    // Set to TRUE if being used on a device that can detect a users location
    public $streetViewAddressControl = true;                        // If set to FALSE will hide the Address control
    public $streetViewAddressPosition = '';                        // The position of the Address control, eg. 'BOTTOM'
    public $streetViewControlPosition = '';                        // The position of the Street View control when viewing normal aerial map, eg. 'BOTTOM_RIGHT'
    public $streetViewCloseButton = false;                    // If set to TRUE will show the close button in the top right. The close button allows users to return to the aerial map
    public $streetViewLinksControl = true;                        // If set to FALSE will hide the Links control
    public $streetViewPanControl = true;                        // If set to FALSE will hide the Pan control
    public $streetViewPanPosition = '';                        // The position of the Scale control, eg. 'TOP_RIGHT'
    public $streetViewPovHeading = 0;                        // The Street View camera heading in degrees relative to true north. True north is 0, east is 90, south is 180, west is 270
    public $streetViewPovPitch = 0;                        // The Street View camera pitch in degrees, relative to the street view vehicle. Directly upwards is 90, Directly downwards is -90.
    public $streetViewPovZoom = 0;                        // The Street View zoom level. Fully zoomed-out is level 0, zooming in increases the zoom level.
    public $streetViewZoomControl = true;                        // If set to FALSE will hide the Zoom control
    public $streetViewZoomPosition = '';                        // The position of the Scale control, eg. 'TOP_RIGHT'
    public $streetViewZoomStyle = '';                        // The size of the Street View zoom control. blank, 'SMALL' or 'LARGE' values accepted.
    public $styles = array();                    // An array of styles used to colour aspects of the map and turn points of interest on and off
    public $stylesAsMapTypes = false;                    // If applying styles, whether to apply them to the default map or add them as additional map types
    public $stylesAsMapTypesDefault = '';                        // If $stylesAsMapTypes is true the default style. Should contain the 'Name' of the style
    public $tilt = 0;                        // The angle of tilt. Currently only supports the values 0 and 45 in SATELLITE and HYBRID map types and at certain zoom levels
    public $trafficOverlay = false;                    // If set to TRUE will overlay traffic information onto the map by default
    public $version = "3";                        // Version of the API being used. Not currently used in the library
    public $zoom = 13;                        // The default zoom level of the map. If set to "auto" will autozoom/center to fit in all visible markers. If "auto", also overrides the $center parameter
    public $zoomControlPosition = '';                        // The position of the Zoom control, eg. 'BOTTOM_RIGHT'
    public $zoomControlStyle = '';                        // The size of the zoom control. blank, 'SMALL' or 'LARGE' values accepted.

    public $markers = array();                    // An array used by the library to store the markers as they are produced
    public $markersInfo = array();                    // An array containing marker information (id, latitude, longitude etc) for use elsewhere
    public $polylines = array();                    // An array used by the library to store the polylines as they are produced
    public $polygons = array();                    // An array used by the library to store the polygons as they are produced
    public $circles = array();                    // An array used by the library to store the circles as they are produced
    public $rectangles = array();                    // An array used by the library to store the rectangles as they are produced
    public $overlays = array();                    // An array used by the library to store the overlays as they are produced

    public $directions = false;                    // Whether or not the map will be used to show directions
    public $directionsStart = "";                        // The starting location (lat/long co-ordinate or address) of the directions. Set to 'auto' to default it to the users location
    public $directionsEnd = "";                        // The destination point (lat/long co-ordinate or address) of the directions. Set to 'auto' to default it to the users location
    public $directionsDivID = "";                        // An element's ID on the page where textual directions will be output to. Leave blank if not required
    public $directionsMode = "DRIVING";                // DRIVING, WALKING or BICYCLING (US Only) - The vehicle/mode of transport to show directions for
    public $directionsAvoidTolls = false;                    // Whether or not directions should avoid tolls
    public $directionsAvoidHighways = false;                    // Whether or not directions should avoid highways
    public $directionsDraggable = false;                    // Whether or not directions on the map are draggable
    public $directionsChanged = "";                        // JavaScript to perform when directions are dragged
    public $directionsUnits = "";                        // 'metric' for kilometers and meters or 'imperial for miles and feet. Leave blank and it will default to the region or country of where directions are being obtained
    public $directionsWaypointArray = array();                    // An array of waypoints. eg array("Boston, MA", "Times Square, NY");
    public $directionsWaypointsOptimize = false;                    // Should the waypoints be optimised? If TRUE, waypoints will be re-ordered to provide the most efficient route.

    public $drawing = false;                    // Whether or not the drawing library tools will be loaded
    public $drawingControl = true;                        // If set to FALSE will hide the Drawing Manager control
    public $drawingControlPosition = 'TOP_CENTER';                // The position of the Drawing Manager control, eg. 'TOP_RIGHT'
    public $drawingDefaultMode = 'marker';                    // The default mode for the Drawing Manager. Accepted values are marker, polygon, polyline, rectangle, circle, or null. null means that the user can interact with the map as normal when the map loads, and clicks do not draw anything.
    public $drawingModes = array();                    // An array of modes available for use. Accepted values are marker, polygon, polyline, rectangle, circle
    public $drawingOnComplete = array();                    // An array of JS to execute when shapes are completed, one array element per shape. For example: array('circle'=>'JS here', 'polygon'=>'JS here');
    public $drawingOnEdit = array();                    // An array of JS to execute when shapes are changed/resized, one array element per shape. For example: array('circle'=>'JS here', 'polygon'=>'JS here');

    public $places = false;                    // Whether or not the map will be used to show places
    public $placesLocation = '';                        // A point (lat/long co-ordinate or address) on the map if the search for places is based around a central point
    public $placesRadius = 0;                        // The radius (in meters) if search is based around a central position
    public $placesLocationSW = '';                        // If preferring to search within bounds the South-West position (latitude/longitude coordinate OR address)
    public $placesLocationNE = '';                        // If preferring to search within bounds the North-East position (latitude/longitude coordinate OR address)
    public $placesTypes = array();                    // The types of places to search for. For a list of supported types see http://code.google.com/apis/maps/documentation/places/supported_types.html
    public $placesName = '';                        // A term to be matched against when searching for places to display on the map
    public $placesAutocompleteInputID = '';                        // The ID attribute of the textfield that the autocomplete should effect
    public $placesAutocompleteTypes = array();                    // The types of places for the autocomplete to return. Options can be seen here https://developers.google.com/maps/documentation/javascript/places#places_autocomplete but include 'establishment' to only return business results, '(cities)', or '(regions)'
    public $placesAutocompleteBoundSW = '';                        // By specifying an area in which to search for Places, the results are biased towards, but not restricted to, Places contained within these bounds.
    public $placesAutocompleteBoundNE = '';                        // Both South-West (lat/long co-ordinate or address) and North-East (lat/long co-ordinate or address) values are required if wishing to set bounds
    public $placesAutocompleteBoundsMap = false;                    // An alternative to setting the SW and NE bounds is to use the bounds of the current viewport. If set to TRUE, the bounds will be set to the viewport of the visible map, even if dragged or zoomed
    public $placesAutocompleteOnChange = '';                        // The JavaScript action to perform when a place is selected
    public $palcesAutoCompleteOnChangeFailed = '';

    public $injectControlsInTopLeft = array();
    public $injectControlsInTopRight = array();
    public $injectControlsInTopCenter = array();
    public $injectControlsInLeftTop = array();
    public $injectControlsInLeftCenter = array();
    public $injectControlsInLeftBottom = array();
    public $injectControlsInRightTop = array();
    public $injectControlsInRightCenter = array();
    public $injectControlsInRightBottom = array();
    public $injectControlsInBottomLeft = array();
    public $injectControlsInBottomRight = array();
    public $injectControlsInBottomCenter = array();

    //user callbacks
    public $init_call_func = '';


    public function __construct($config = array())
    {
        $this->apiKey = config('googlemaps.key');
        $this->adsensePublisherID = config('googlemaps.adsense_publisher_id');
        $this->class = config('googlemaps.css_class');

        if (count($config) > 0) {
            $this->initialize($config);
        }

        #Log::info('debug', "Google Maps Class Initialized");
    }

    public function initialize($config = array())
    {
        foreach ($config as $key => $val) {
            if (isset($this->$key)) {
                $this->$key = $val;
            }
        }

        if ($this->sensor) {
            $this->sensor = "true";
        } else {
            $this->sensor = "false";
        }
    }

    public function add_marker($params = array())
    {
        $marker = array();
        $this->markersInfo['marker_'.count($this->markers)] = array();

        $marker['position'] = '';                                // The position (lat/long co-ordinate or address) at which the marker will appear
        $marker['infowindow_content'] = '';                        // If not blank, creates an infowindow (aka bubble) with the content provided. Can be plain text or HTML
        $marker['id'] = '';                                        // The unique identifier of the marker suffix (ie. marker_yourID). If blank, this will default to marker_X where X is an incremental number
        $marker['clickable'] = true;                            // Defines if the marker is clickable
        $marker['cursor'] = '';                                    // The name or url of the cursor to display on hover
        $marker['draggable'] = false;                            // Defines if the marker is draggable
        $marker['flat'] = false;                                // If set to TRUE will not display a shadow beneath the icon
        $marker['icon'] = '';                                    // The name or url of the icon to use for the marker
        $marker['icon_size'] = '';                                // The display size of the sprite or image being used. When using sprites, you must specify the sprite size. Expecting two comma-separated values for width and height respectively (ie '20,30'). See https://developers.google.com/maps/documentation/javascript/3.exp/reference#Icon
        $marker['icon_scaledSize'] = '';                        // The size of the entire image after scaling, if any. Use this property to stretch/shrink an image or a sprite. Expecting two comma-separated values for width and height respectively (ie '20,30')
        $marker['icon_origin'] = '';                            // If using a sprite, the position of the image within the sprite. Expecting two comma-separated values for distance from the top and left respectively (ie '20,30')
        $marker['icon_anchor'] = '';                            // The position at which to anchor an image in correspondance to the location of the marker on the map. By default, the anchor is located along the center point of the bottom of the image. Expecting two comma-separated values (ie '20,30'). Credit to https://github.com/colethorsen
        $marker['animation'] = '';                                // blank, 'DROP' or 'BOUNCE'
        $marker['onclick'] = '';                                // JavaScript performed when a marker is clicked
        $marker['ondblclick'] = '';                                // JavaScript performed when a marker is double-clicked
        $marker['ondrag'] = '';                                    // JavaScript repeatedly performed while the marker is being dragged
        $marker['ondragstart'] = '';                            // JavaScript performed when a marker is started to be dragged
        $marker['ondragend'] = '';                                // JavaScript performed when a draggable marker is dropped
        $marker['onmousedown'] = '';                            // JavaScript performed when a mousedown event occurs on a marker
        $marker['onmouseout'] = '';                                // JavaScript performed when the mouse leaves the area of the marker icon
        $marker['onmouseover'] = '';                            // JavaScript performed when the mouse enters the area of the marker icon
        $marker['onmouseup'] = '';                                // JavaScript performed when a mouseup event occurs on a marker
        $marker['onpositionchanged'] = '';                        // JavaScript performed when the markers position changes
        $marker['onrightclick'] = '';                            // JavaScript performed when a right-click occurs on a marker
        $marker['raiseondrag'] = true;                            // If FALSE, disables the raising and lowering of the icon when a marker is being dragged
        $marker['shadow'] = '';                                    // The name or url of the icon's shadow
        $marker['title'] = '';                                    // The tooltip text to show on hover
        $marker['visible'] = true;                                // Defines if the marker is visible by default
        $marker['zIndex'] = '';                                    // The zIndex of the marker. If two markers overlap, the marker with the higher zIndex will appear on top
        $marker['label'] = '';                                    // The label of the marker.

        $marker_output = '';

        foreach ($params as $key => $value) {
            if (isset($marker[$key])) {
                $marker[$key] = $value;
            }
        }

        $marker_id = count($this->markers);
        if (trim($marker['id']) != "") {
            $marker_id = $marker['id'];
        }

        if ($marker['position'] != "") {
            if ($this->is_lat_long($marker['position'])) {
                //Javascript
                $marker_output .= 'var myLatlng = new google.maps.LatLng('.$marker['position'].');';

                $explodePosition = explode(",", $marker['position']);
                $this->markersInfo['marker_'.$marker_id]['latitude'] = trim($explodePosition[0]);
                $this->markersInfo['marker_'.$marker_id]['longitude'] = trim($explodePosition[1]);
            } else {
                $lat_long = $this->get_lat_long_from_address($marker['position']);
                $marker_output .= 'var myLatlng = new google.maps.LatLng('.$lat_long[0].', '.$lat_long[1].');';
                $this->markersInfo['marker_'.$marker_id]['latitude'] = $lat_long[0];
                $this->markersInfo['marker_'.$marker_id]['longitude'] = $lat_long[1];
            }
        }

        if ($marker['icon'] != "") {
            $marker_output .= '
                var marker_icon = {
                    url: "'.$marker['icon'].'"';
            if ($marker['icon_size'] != "") {
                $marker_output .= ',
                    size: new google.maps.Size('.$marker['icon_size'].')';
            }
            if ($marker['icon_scaledSize'] != "") {
                $marker_output .= ',
                    scaledSize: new google.maps.Size('.$marker['icon_scaledSize'].')';
            }
            if ($marker['icon_origin'] != "") {
                $marker_output .= ',
                    origin: new google.maps.Point('.$marker['icon_origin'].')';
            }
            if ($marker['icon_anchor'] != "") {
                $marker_output .= ',
                    anchor: new google.maps.Point('.$marker['icon_anchor'].')';
            }
            $marker_output .= '};
            ';
        }

        $marker_output .= '
            var markerOptions = {
                map: '.$this->map_name;
        if ($marker['position'] != "") {
            $marker_output .= ',
                position: myLatlng';
        }
        if (!$marker['clickable']) {
            $marker_output .= ',
                clickable: false';
        }
        if ($marker['cursor'] != "") {
            $marker_output .= ',
                cursor: "'.$marker['cursor'].'"';
        }
        if ($marker['draggable']) {
            $marker_output .= ',
                draggable: true';
        }
        if ($marker['flat']) {
            $marker_output .= ',
                flat: true';
        }
        if ($marker['icon'] != "") {
            $marker_output .= ',
                icon: marker_icon';
        }
        if (!$marker['raiseondrag']) {
            $marker_output .= ',
                raiseOnDrag: false';
        }
        if ($marker['shadow'] != "") {
            $marker_output .= ',
                shadow: "'.$marker['shadow'].'"';
        }
        if ($marker['title'] != "") {
            $marker_output .= ',
                title: "'.$marker['title'].'"';
            $this->markersInfo['marker_'.$marker_id]['title'] = $marker['title'];
        }
        if (!$marker['visible']) {
            $marker_output .= ',
                visible: false';
        }
        if ($marker['zIndex'] != "" && is_numeric($marker['zIndex'])) {
            $marker_output .= ',
                zIndex: '.$marker['zIndex'];
        }
        if ($marker['animation'] != "" && (strtoupper($marker['animation']) == "DROP" || strtoupper($marker['animation'] == "BOUNCE"))) {
            $marker_output .= ',
                animation:  google.maps.Animation.'.strtoupper($marker['animation']);
        }
        if ($marker['label'] != "") {
            $marker_output .= ',
                label: "'.$marker['label'].'"';
        }



        $marker_output .= '
            };
            marker_'.$marker_id.' = createMarker_'.$this->map_name.'(markerOptions);
            marker_'.$marker_id.'.id = marker_'.$marker_id.';
            ';

        if ($marker['infowindow_content'] != "") {

            // Escape any quotes in the event that HTML is being added to the infowindow
            $marker['infowindow_content'] = str_replace('\"', '"', $marker['infowindow_content']);
            $marker['infowindow_content'] = str_replace('"', '\"', $marker['infowindow_content']);

            $marker_output .= '
            marker_'.$marker_id.'.set("content", "'.$marker['infowindow_content'].'");

            google.maps.event.addListener(marker_'.$marker_id.', "click", function(event) {
                iw_'.$this->map_name.'.setContent(this.get("content"));
                iw_'.$this->map_name.'.open('.$this->map_name.', this);
            ';
            if ($marker['onclick'] != "") {
                $marker_output .= $marker['onclick'].'
            ';
            }
            $marker_output .= '
            });
            ';
        } else {
            if ($marker['onclick'] != "") {
                $marker_output .= '
                google.maps.event.addListener(marker_'.$marker_id.', "click", function(event) {
                    '.$marker['onclick'].'
                });
                ';
            }
        }

        if ($marker['ondblclick'] != "") {
            $marker_output .= '
            google.maps.event.addListener(marker_'.$marker_id.', "dblclick", function(event) {
                '.$marker['ondblclick'].'
            });
            ';
        }
        if ($marker['onmousedown'] != "") {
            $marker_output .= '
            google.maps.event.addListener(marker_'.$marker_id.', "mousedown", function(event) {
                '.$marker['onmousedown'].'
            });
            ';
        }
        if ($marker['onmouseout'] != "") {
            $marker_output .= '
            google.maps.event.addListener(marker_'.$marker_id.', "mouseout", function(event) {
                '.$marker['onmouseout'].'
            });
            ';
        }
        if ($marker['onmouseover'] != "") {
            $marker_output .= '
            google.maps.event.addListener(marker_'.$marker_id.', "mouseover", function(event) {
                '.$marker['onmouseover'].'
            });
            ';
        }
        if ($marker['onmouseup'] != "") {
            $marker_output .= '
            google.maps.event.addListener(marker_'.$marker_id.', "mouseup", function(event) {
                '.$marker['onmouseup'].'
            });
            ';
        }
        if ($marker['onpositionchanged'] != "") {
            $marker_output .= '
            google.maps.event.addListener(marker_'.$marker_id.', "position_changed", function(event) {
                '.$marker['onpositionchanged'].'(event, this);
            });
            ';
        }
        if ($marker['onrightclick'] != "") {
            $marker_output .= '
            google.maps.event.addListener(marker_'.$marker_id.', "rightclick", function(event) {
                '.$marker['onrightclick'].'
            });
            ';
        }

        if ($marker['draggable']) {
            if ($marker['ondrag'] != "") {
                $marker_output .= '
                google.maps.event.addListener(marker_'.$marker_id.', "drag", function(event) {
                    '.$marker['ondrag'].'
                });
                ';
            }
            if ($marker['ondragend'] != "") {
                $marker_output .= '
                google.maps.event.addListener(marker_'.$marker_id.', "dragend", function(event) {
                    '.$marker['ondragend'].'
                });
                ';
            }
            if ($marker['ondragstart'] != "") {
                $marker_output .= '
                google.maps.event.addListener(marker_'.$marker_id.', "dragstart", function(event) {
                    '.$marker['ondragstart'].'
                });
                ';
            }
        }

        array_push($this->markers, $marker_output);
    }

    public function add_polyline($params = array())
    {
        $polyline = array();

        $polyline['points'] = array();                            // An array of latitude/longitude coordinates OR addresses, or a mixture of both. If an address is supplied the Google geocoding service will be used to return a lat/long.
        $polyline['clickable'] = true;                            // Defines if the polyline is clickable
        $polyline['strokeColor'] = '#FF0000';                    // The hex value of the polylines color
        $polyline['strokeOpacity'] = '1.0';                        // The opacity of the polyline. 0 to 1.0
        $polyline['strokeWeight'] = '2';                        // The thickness of the polyline
        $polyline['onclick'] = '';                                // JavaScript performed when a polyline is clicked
        $polyline['ondblclick'] = '';                            // JavaScript performed when a polyline is double-clicked
        $polyline['onmousedown'] = '';                            // JavaScript performed when a mousedown event occurs on a polyline
        $polyline['onmousemove'] = '';                            // JavaScript performed when the mouse moves in the area of the polyline
        $polyline['onmouseout'] = '';                            // JavaScript performed when the mouse leaves the area of the polyline
        $polyline['onmouseover'] = '';                            // JavaScript performed when the mouse enters the area of the polyline
        $polyline['onmouseup'] = '';                            // JavaScript performed when a mouseup event occurs on a polyline
        $polyline['onrightclick'] = '';                            // JavaScript performed when a right-click occurs on a polyline
        $polyline['zIndex'] = '';                                // The zIndex of the polyline. If two polylines overlap, the polyline with the higher zIndex will appear on top

        $polyline_output = '';

        foreach ($params as $key => $value) {
            if (isset($polyline[$key])) {
                $polyline[$key] = $value;
            }
        }

        if (count($polyline['points'])) {
            $polyline_output .= '
                var polyline_plan_'.count($this->polylines).' = [';
            $i = 0;
            $lat_long_output = '';
            foreach ($polyline['points'] as $point) {
                if ($i > 0) {
                    $polyline_output .= ',';
                }
                $lat_long_to_push = '';
                if ($this->is_lat_long($point)) {
                    $lat_long_to_push = $point;
                    $polyline_output .= '
                    new google.maps.LatLng('.$point.')
                    ';
                } else {
                    $lat_long = $this->get_lat_long_from_address($point);
                    $polyline_output .= '
                    new google.maps.LatLng('.$lat_long[0].', '.$lat_long[1].')';
                    $lat_long_to_push = $lat_long[0].', '.$lat_long[1];
                }
                $lat_long_output .= '
                    lat_longs_'.$this->map_name.'.push(new google.maps.LatLng('.$lat_long_to_push.'));
                ';
                $i++;
            }
            $polyline_output .= '];';

            $polyline_output .= $lat_long_output;

            $polyline_output .= '
                var polyline_'.count($this->polylines).' = new google.maps.Polyline({
                    path: polyline_plan_'.count($this->polylines).',
                    strokeColor: "'.$polyline['strokeColor'].'",
                    strokeOpacity: '.$polyline['strokeOpacity'].',
                    strokeWeight: '.$polyline['strokeWeight'];
            if (!$polyline['clickable']) {
                $polyline_output .= ',
                    clickable: false';
            }
            if ($polyline['zIndex'] != "" && is_numeric($polyline['zIndex'])) {
                $polyline_output .= ',
                    zIndex: '.$polyline['zIndex'];
            }
            $polyline_output .= '
                });

                polyline_'.count($this->polylines).'.setMap('.$this->map_name.');

            ';

            if ($polyline['onclick'] != "") {
                $polyline_output .= '
                google.maps.event.addListener(polyline_'.count($this->polylines).', "click", function() {
                    '.$polyline['onclick'].'
                });
                ';
            }
            if ($polyline['ondblclick'] != "") {
                $polyline_output .= '
                google.maps.event.addListener(polyline_'.count($this->polylines).', "dblclick", function() {
                    '.$polyline['ondblclick'].'
                });
                ';
            }
            if ($polyline['onmousedown'] != "") {
                $polyline_output .= '
                google.maps.event.addListener(polyline_'.count($this->polylines).', "mousedown", function() {
                    '.$polyline['onmousedown'].'
                });
                ';
            }
            if ($polyline['onmousemove'] != "") {
                $polyline_output .= '
                google.maps.event.addListener(polyline_'.count($this->polylines).', "mousemove", function() {
                    '.$polyline['onmousemove'].'
                });
                ';
            }
            if ($polyline['onmouseout'] != "") {
                $polyline_output .= '
                google.maps.event.addListener(polyline_'.count($this->polylines).', "mouseout", function() {
                    '.$polyline['onmouseout'].'
                });
                ';
            }
            if ($polyline['onmouseover'] != "") {
                $polyline_output .= '
                google.maps.event.addListener(polyline_'.count($this->polylines).', "mouseover", function() {
                    '.$polyline['onmouseover'].'
                });
                ';
            }
            if ($polyline['onmouseup'] != "") {
                $polyline_output .= '
                google.maps.event.addListener(polyline_'.count($this->polylines).', "mouseup", function() {
                    '.$polyline['onmouseup'].'
                });
                ';
            }
            if ($polyline['onrightclick'] != "") {
                $polyline_output .= '
                google.maps.event.addListener(polyline_'.count($this->polylines).', "rightclick", function() {
                    '.$polyline['onrightclick'].'
                });
                ';
            }

            array_push($this->polylines, $polyline_output);
        }
    }

    public function add_polygon($params = array())
    {
        $polygon = array();

        $polygon['points'] = array();                            // The positions (latitude/longitude coordinates OR addresses) at which the polygon points will appear. NOTE: The first and last elements of the array must be the same
        $polygon['clickable'] = true;                            // Defines if the polygon is clickable
        $polygon['strokeColor'] = '#FF0000';                    // The hex value of the polygons border color
        $polygon['strokeOpacity'] = '0.8';                        // The opacity of the polygon border. 0 to 1.0
        $polygon['strokeWeight'] = '2';                            // The thickness of the polygon border
        $polygon['fillColor'] = '#FF0000';                        // The hex value of the polygons fill color
        $polygon['fillOpacity'] = '0.3';                        // The opacity of the polygons fill
        $polygon['onclick'] = '';                                // JavaScript performed when a polygon is clicked
        $polygon['ondblclick'] = '';                            // JavaScript performed when a polygon is double-clicked
        $polygon['onmousedown'] = '';                            // JavaScript performed when a mousedown event occurs on a polygon
        $polygon['onmousemove'] = '';                            // JavaScript performed when the mouse moves in the area of the polygon
        $polygon['onmouseout'] = '';                            // JavaScript performed when the mouse leaves the area of the polygon
        $polygon['onmouseover'] = '';                            // JavaScript performed when the mouse enters the area of the polygon
        $polygon['onmouseup'] = '';                                // JavaScript performed when a mouseup event occurs on a polygon
        $polygon['onrightclick'] = '';                            // JavaScript performed when a right-click occurs on a polygon
        $polygon['zIndex'] = '';                                // The zIndex of the polygon. If two polygons overlap, the polygon with the higher zIndex will appear on top

        $polygon_output = '';

        foreach ($params as $key => $value) {
            if (isset($polygon[$key])) {
                $polygon[$key] = $value;
            }
        }

        if (count($polygon['points'])) {
            $polygon_output .= '
                var polygon_plan_'.count($this->polygons).' = [';
            $i = 0;
            $lat_long_output = '';
            foreach ($polygon['points'] as $point) {
                if ($i > 0) {
                    $polygon_output .= ',';
                }
                $lat_long_to_push = '';
                if ($this->is_lat_long($point)) {
                    $lat_long_to_push = $point;
                    $polygon_output .= '
                    new google.maps.LatLng('.$point.')
                    ';
                } else {
                    $lat_long = $this->get_lat_long_from_address($point);
                    $polygon_output .= '
                    new google.maps.LatLng('.$lat_long[0].', '.$lat_long[1].')';
                    $lat_long_to_push = $lat_long[0].', '.$lat_long[1];
                }
                $lat_long_output .= '
                    lat_longs_'.$this->map_name.'.push(new google.maps.LatLng('.$lat_long_to_push.'));
                ';
                $i++;
            }
            $polygon_output .= '];';

            $polygon_output .= $lat_long_output;
        }

        $polygon_output .= '
            var polygon_'.count($this->polygons).' = new google.maps.Polygon({
                ';
        if (count($polygon['points'])) {
            $polygon_output .= 'path: polygon_plan_'.count($this->polygons).',
                    ';
        }
        $polygon_output .= '
                strokeColor: "'.$polygon['strokeColor'].'",
                strokeOpacity: '.$polygon['strokeOpacity'].',
                strokeWeight: '.$polygon['strokeWeight'].',
                fillColor: "'.$polygon['fillColor'].'",
                fillOpacity: '.$polygon['fillOpacity'];
        if (!$polygon['clickable']) {
            $polygon_output .= ',
                clickable: false';
        }
        if ($polygon['zIndex'] != "" && is_numeric($polygon['zIndex'])) {
            $polygon_output .= ',
                zIndex: '.$polygon['zIndex'];
        }
        $polygon_output .= '
            });

            polygon_'.count($this->polygons).'.setMap('.$this->map_name.');

        ';

        if ($polygon['onclick'] != "") {
            $polygon_output .= '
            google.maps.event.addListener(polygon_'.count($this->polygons).', "click", function() {
                '.$polygon['onclick'].'
            });
            ';
        }
        if ($polygon['ondblclick'] != "") {
            $polygon_output .= '
            google.maps.event.addListener(polygon_'.count($this->polygons).', "dblclick", function() {
                '.$polygon['ondblclick'].'
            });
            ';
        }
        if ($polygon['onmousedown'] != "") {
            $polygon_output .= '
            google.maps.event.addListener(polygon_'.count($this->polygons).', "mousedown", function() {
                '.$polygon['onmousedown'].'
            });
            ';
        }
        if ($polygon['onmousemove'] != "") {
            $polygon_output .= '
            google.maps.event.addListener(polygon_'.count($this->polygons).', "mousemove", function() {
                '.$polygon['onmousemove'].'
            });
            ';
        }
        if ($polygon['onmouseout'] != "") {
            $polygon_output .= '
            google.maps.event.addListener(polygon_'.count($this->polygons).', "mouseout", function() {
                '.$polygon['onmouseout'].'
            });
            ';
        }
        if ($polygon['onmouseover'] != "") {
            $polygon_output .= '
            google.maps.event.addListener(polygon_'.count($this->polygons).', "mouseover", function() {
                '.$polygon['onmouseover'].'
            });
            ';
        }
        if ($polygon['onmouseup'] != "") {
            $polygon_output .= '
            google.maps.event.addListener(polygon_'.count($this->polygons).', "mouseup", function() {
                '.$polygon['onmouseup'].'
            });
            ';
        }
        if ($polygon['onrightclick'] != "") {
            $polygon_output .= '
            google.maps.event.addListener(polygon_'.count($this->polygons).', "rightclick", function() {
                '.$polygon['onrightclick'].'
            });
            ';
        }

        array_push($this->polygons, $polygon_output);
    }

    public function add_circle($params = array())
    {
        $circle = array();

        $circle['center'] = '';                                    // The center position (latitude/longitude coordinate OR addresse) at which the circle will appear
        $circle['clickable'] = true;                            // Defines if the circle is clickable
        $circle['radius'] = 0;                                    // The circle radius (in metres)
        $circle['strokeColor'] = '0.8';                            // The hex value of the circles border color
        $circle['strokeOpacity'] = '0.8';                        // The opacity of the circle border
        $circle['strokeWeight'] = '2';                            // The thickness of the circle border
        $circle['fillColor'] = '#FF0000';                        // The hex value of the circles fill color
        $circle['fillOpacity'] = '0.3';                            // The opacity of the circles fill
        $circle['onclick'] = '';                                // JavaScript performed when a circle is clicked
        $circle['ondblclick'] = '';                                // JavaScript performed when a circle is double-clicked
        $circle['onmousedown'] = '';                            // JavaScript performed when a mousedown event occurs on a circle
        $circle['onmousemove'] = '';                            // JavaScript performed when the mouse moves in the area of the circle
        $circle['onmouseout'] = '';                                // JavaScript performed when the mouse leaves the area of the circle
        $circle['onmouseover'] = '';                            // JavaScript performed when the mouse enters the area of the circle
        $circle['onmouseup'] = '';                                // JavaScript performed when a mouseup event occurs on a circle
        $circle['onrightclick'] = '';                            // JavaScript performed when a right-click occurs on a circle
        $circle['zIndex'] = '';                                    // The zIndex of the circle. If two circles overlap, the circle with the higher zIndex will appear on top

        $circle_output = '';

        foreach ($params as $key => $value) {
            if (isset($circle[$key])) {
                $circle[$key] = $value;
            }
        }

        if ($circle['radius'] > 0 && $circle['center'] != "") {
            $lat_long_to_push = '';
            if ($this->is_lat_long($circle['center'])) {
                $lat_long_to_push = $circle['center'];
                $circle_output = '
                var circleCenter = new google.maps.LatLng('.$circle['center'].')
                ';
            } else {
                $lat_long = $this->get_lat_long_from_address($circle['center']);
                $circle_output = '
                var circleCenter = new google.maps.LatLng('.$lat_long[0].', '.$lat_long[1].')';
                $lat_long_to_push = $lat_long[0].', '.$lat_long[1];
            }
            $circle_output .= '
                lat_longs_'.$this->map_name.'.push(new google.maps.LatLng('.$lat_long_to_push.'));
            ';

            $circle_output .= '
                var circleOptions = {
                    strokeColor: "'.$circle['strokeColor'].'",
                    strokeOpacity: '.$circle['strokeOpacity'].',
                    strokeWeight: '.$circle['strokeWeight'].',
                    fillColor: "'.$circle['fillColor'].'",
                    fillOpacity: '.$circle['fillOpacity'].',
                    map: '.$this->map_name.',
                    center: circleCenter,
                    radius: '.$circle['radius'];
            if (!$circle['clickable']) {
                $circle_output .= ',
                    clickable: false';
            }
            if ($circle['zIndex'] != "" && is_numeric($circle['zIndex'])) {
                $circle_output .= ',
                    zIndex: '.$circle['zIndex'];
            }
            $circle_output .= '
                };
                var circle_'.count($this->circles).' = new google.maps.Circle(circleOptions);
            ';

            if ($circle['onclick'] != "") {
                $circle_output .= '
                google.maps.event.addListener(circle_'.count($this->circles).', "click", function() {
                    '.$circle['onclick'].'
                });
                ';
            }
            if ($circle['ondblclick'] != "") {
                $circle_output .= '
                google.maps.event.addListener(circle_'.count($this->circles).', "dblclick", function() {
                    '.$circle['ondblclick'].'
                });
                ';
            }
            if ($circle['onmousedown'] != "") {
                $circle_output .= '
                google.maps.event.addListener(circle_'.count($this->circles).', "mousedown", function() {
                    '.$circle['onmousedown'].'
                });
                ';
            }
            if ($circle['onmousemove'] != "") {
                $circle_output .= '
                google.maps.event.addListener(circle_'.count($this->circles).', "mousemove", function() {
                    '.$circle['onmousemove'].'
                });
                ';
            }
            if ($circle['onmouseout'] != "") {
                $circle_output .= '
                google.maps.event.addListener(circle_'.count($this->circles).', "mouseout", function() {
                    '.$circle['onmouseout'].'
                });
                ';
            }
            if ($circle['onmouseover'] != "") {
                $circle_output .= '
                google.maps.event.addListener(circle_'.count($this->circles).', "mouseover", function() {
                    '.$circle['onmouseover'].'
                });
                ';
            }
            if ($circle['onmouseup'] != "") {
                $circle_output .= '
                google.maps.event.addListener(circle_'.count($this->circles).', "mouseup", function() {
                    '.$circle['onmouseup'].'
                });
                ';
            }
            if ($circle['onrightclick'] != "") {
                $circle_output .= '
                google.maps.event.addListener(circle_'.count($this->circles).', "rightclick", function() {
                    '.$circle['onrightclick'].'
                });
                ';
            }

            array_push($this->circles, $circle_output);
        }
    }

    public function add_rectangle($params = array())
    {
        $rectangle = array();

        $rectangle['positionSW'] = '';                            // The South-West position (latitude/longitude coordinate OR address) at which the rectangle will appear
        $rectangle['positionNE'] = '';                            // The North-East position(latitude/longitude coordinate OR address) at which the rectangle will appear
        $rectangle['clickable'] = true;                            // Defines if the rectangle is clickable
        $rectangle['strokeColor'] = '0.8';                        // The hex value of the rectangles border color
        $rectangle['strokeOpacity'] = '0.8';                    // The opacity of the rectangle border
        $rectangle['strokeWeight'] = '2';                        // The thickness of the rectangle border
        $rectangle['fillColor'] = '#FF0000';                    // The hex value of the rectangles fill color
        $rectangle['fillOpacity'] = '0.3';                        // The opacity of the rectangles fill
        $rectangle['onclick'] = '';                                // JavaScript performed when a rectangle is clicked
        $rectangle['ondblclick'] = '';                            // JavaScript performed when a rectangle is double-clicked
        $rectangle['onmousedown'] = '';                            // JavaScript performed when a mousedown event occurs on a rectangle
        $rectangle['onmousemove'] = '';                            // JavaScript performed when the mouse moves in the area of the rectangle
        $rectangle['onmouseout'] = '';                            // JavaScript performed when the mouse leaves the area of the rectangle
        $rectangle['onmouseover'] = '';                            // JavaScript performed when the mouse enters the area of the rectangle
        $rectangle['onmouseup'] = '';                            // JavaScript performed when a mouseup event occurs on a rectangle
        $rectangle['onrightclick'] = '';                        // JavaScript performed when a right-click occurs on a rectangle
        $rectangle['zIndex'] = '';                                // The zIndex of the rectangle. If two rectangles overlap, the rectangle with the higher zIndex will appear on top

        $rectangle_output = '';

        foreach ($params as $key => $value) {
            if (isset($rectangle[$key])) {
                $rectangle[$key] = $value;
            }
        }

        if ($rectangle['positionSW'] != "" && $rectangle['positionNE'] != "") {
            $lat_long_to_push = '';
            if ($this->is_lat_long($rectangle['positionSW'])) {
                $lat_long_to_push = $rectangle['positionSW'];
                $rectangle_output .= '
                var positionSW = new google.maps.LatLng('.$rectangle['positionSW'].')
                ';
            } else {
                $lat_long = $this->get_lat_long_from_address($rectangle['positionSW']);
                $rectangle_output .= '
                var positionSW = new google.maps.LatLng('.$lat_long[0].', '.$lat_long[1].')';
                $lat_long_to_push = $lat_long[0].', '.$lat_long[1];
            }
            $rectangle_output .= '
                lat_longs_'.$this->map_name.'.push(new google.maps.LatLng('.$lat_long_to_push.'));
            ';

            $lat_long_to_push = '';
            if ($this->is_lat_long($rectangle['positionNE'])) {
                $lat_long_to_push = $rectangle['positionNE'];
                $rectangle_output .= '
                var positionNE = new google.maps.LatLng('.$rectangle['positionNE'].')
                ';
            } else {
                $lat_long = $this->get_lat_long_from_address($rectangle['positionNE']);
                $rectangle_output .= '
                var positionNE = new google.maps.LatLng('.$lat_long[0].', '.$lat_long[1].')';
                $lat_long_to_push = $lat_long[0].', '.$lat_long[1];
            }
            $rectangle_output .= '
                lat_longs_'.$this->map_name.'.push(new google.maps.LatLng('.$lat_long_to_push.'));
            ';

            $rectangle_output .= '
                var rectangleOptions = {
                    strokeColor: "'.$rectangle['strokeColor'].'",
                    strokeOpacity: '.$rectangle['strokeOpacity'].',
                    strokeWeight: '.$rectangle['strokeWeight'].',
                    fillColor: "'.$rectangle['fillColor'].'",
                    fillOpacity: '.$rectangle['fillOpacity'].',
                    map: '.$this->map_name.',
                    bounds: new google.maps.LatLngBounds(positionSW, positionNE)';
            if (!$rectangle['clickable']) {
                $rectangle_output .= ',
                    clickable: false';
            }
            if ($rectangle['zIndex'] != "" && is_numeric($rectangle['zIndex'])) {
                $rectangle_output .= ',
                    zIndex: '.$rectangle['zIndex'];
            }
            $rectangle_output .= '
                };';

            $rectangle_output .= '
                var rectangle_'.count($this->rectangles).' = new google.maps.Rectangle(rectangleOptions);
            ';

            if ($rectangle['onclick'] != "") {
                $rectangle_output .= '
                google.maps.event.addListener(rectangle_'.count($this->rectangles).', "click", function() {
                    '.$rectangle['onclick'].'
                });
                ';
            }
            if ($rectangle['ondblclick'] != "") {
                $rectangle_output .= '
                google.maps.event.addListener(rectangle_'.count($this->rectangles).', "dblclick", function() {
                    '.$rectangle['ondblclick'].'
                });
                ';
            }
            if ($rectangle['onmousedown'] != "") {
                $rectangle_output .= '
                google.maps.event.addListener(rectangle_'.count($this->rectangles).', "mousedown", function() {
                    '.$rectangle['onmousedown'].'
                });
                ';
            }
            if ($rectangle['onmousemove'] != "") {
                $rectangle_output .= '
                google.maps.event.addListener(rectangle_'.count($this->rectangles).', "mousemove", function() {
                    '.$rectangle['onmousemove'].'
                });
                ';
            }
            if ($rectangle['onmouseout'] != "") {
                $rectangle_output .= '
                google.maps.event.addListener(rectangle_'.count($this->rectangles).', "mouseout", function() {
                    '.$rectangle['onmouseout'].'
                });
                ';
            }
            if ($rectangle['onmouseover'] != "") {
                $rectangle_output .= '
                google.maps.event.addListener(rectangle_'.count($this->rectangles).', "mouseover", function() {
                    '.$rectangle['onmouseover'].'
                });
                ';
            }
            if ($rectangle['onmouseup'] != "") {
                $rectangle_output .= '
                google.maps.event.addListener(rectangle_'.count($this->rectangles).', "mouseup", function() {
                    '.$rectangle['onmouseup'].'
                });
                ';
            }
            if ($rectangle['onrightclick'] != "") {
                $rectangle_output .= '
                google.maps.event.addListener(rectangle_'.count($this->rectangles).', "rightclick", function() {
                    '.$rectangle['onrightclick'].'
                });
                ';
            }

            array_push($this->rectangles, $rectangle_output);
        }
    }

    public function add_ground_overlay($params = array())
    {
        $overlay = array();

        $overlay['image'] = '';                                    // JavaScript performed when a ground overlay is clicked
        $overlay['positionSW'] = '';                            // The South-West position (latitude/longitude coordinate OR addresse) at which the ground overlay will appear
        $overlay['positionNE'] = '';                            // The North-East position (latitude/longitude coordinate OR addresse) at which the ground overlay will appear
        $overlay['clickable'] = true;                            // Defines if the ground overlay is clickable
        $overlay['onclick'] = '';                                // JavaScript performed when a ground overlay is clicked

        $overlay_output = '';

        foreach ($params as $key => $value) {
            if (isset($overlay[$key])) {
                $overlay[$key] = $value;
            }
        }

        if ($overlay['image'] != "" && $overlay['positionSW'] != "" && $overlay['positionNE'] != "") {
            $lat_long_to_push = '';
            if ($this->is_lat_long($overlay['positionSW'])) {
                $lat_long_to_push = $overlay['positionSW'];
                $overlay_output .= '
                var positionSW = new google.maps.LatLng('.$overlay['positionSW'].')
                ';
            } else {
                $lat_long = $this->get_lat_long_from_address($overlay['positionSW']);
                $overlay_output .= '
                var positionSW = new google.maps.LatLng('.$lat_long[0].', '.$lat_long[1].')';
                $lat_long_to_push = $lat_long[0].', '.$lat_long[1];
            }
            $overlay_output .= '
                lat_longs_'.$this->map_name.'.push(new google.maps.LatLng('.$lat_long_to_push.'));
            ';

            $lat_long_to_push = '';
            if ($this->is_lat_long($overlay['positionNE'])) {
                $lat_long_to_push = $overlay['positionNE'];
                $overlay_output .= '
                var positionNE = new google.maps.LatLng('.$overlay['positionNE'].')
                ';
            } else {
                $lat_long = $this->get_lat_long_from_address($overlay['positionNE']);
                $overlay_output .= '
                var positionNE = new google.maps.LatLng('.$lat_long[0].', '.$lat_long[1].')';
                $lat_long_to_push = $lat_long[0].', '.$lat_long[1];
            }
            $overlay_output .= '
                lat_longs_'.$this->map_name.'.push(new google.maps.LatLng('.$lat_long_to_push.'));
            ';

            $overlay_output .= '
                var overlay_'.count($this->overlays).' = new google.maps.GroundOverlay("'.$overlay['image'].'", new google.maps.LatLngBounds(positionSW, positionNE), { map: '.$this->map_name;
            if (!$overlay['clickable']) {
                $overlay_output .= ', clickable: false';
            }
            $overlay_output .= '});
            ';

            if ($overlay['onclick'] != "") {
                $overlay_output .= '
                google.maps.event.addListener(overlay_'.count($this->overlays).', "click", function() {
                    '.$overlay['onclick'].'
                });
                ';
            }

            array_push($this->overlays, $overlay_output);
        }
    }

    public function create_map()
    {
        $this->output_js = '';
        $this->output_js_contents = '';
        $this->output_html = '';

        $host = 'https';
        if(empty($_SERVER['HTTPS'])){
            $host = 'http';
        }

        if ($this->maps_loaded == 0) {
            if ($this->apiKey != "") {
                $apiLocation = $host.'://maps.googleapis.com/maps/api/js?key='.$this->apiKey.'&sensor='.$this->sensor;
            } else {
                $apiLocation = $host.'://maps.google.com/maps/api/js?sensor='.$this->sensor;
            }
            $apiLocation .= 'sensor='.$this->sensor; //Sensor feature depreciated by google API V3
            if ($this->version != "") {
                $apiLocation .= '&v='.$this->version;
            }
            if ($this->region != "" && strlen($this->region) == 2) {
                $apiLocation .= '&region='.strtoupper($this->region);
            }
            if ($this->language != "") {
                $apiLocation .= '&language='.$this->language;
            }
            $libraries = array();
            if ($this->adsense != "") {
                array_push($libraries, 'adsense');
            }
            if ($this->places != "") {
                array_push($libraries, 'places');
            }
            if ($this->panoramio) {
                array_push($libraries, 'panoramio');
            }
            if ($this->drawing) {
                array_push($libraries, 'drawing');
            }
            if (count($libraries)) {
                $apiLocation .= '&libraries='.implode(",", $libraries);
            }

            if (!$this->loadAsynchronously) {
                $this->output_js .= '

                <script type="text/javascript" src="'.$apiLocation.'"></script>';
            }

            if ($this->cluster) {
                $this->output_js .= '

            <script type="text/javascript" src="'.asset('libs/FarhanWazir/GMaps/markerclusterer.js').'"></script >
                    ';
            }
        }
        if ($this->jsfile == "") {
            $this->output_js .= '
            <script type="text/javascript">
            //<![CDATA[
            ';
        }

        $this->output_js_contents .= '
            var '.$this->map_name.'; // Global declaration of the map
            var lat_longs_'.$this->map_name.' = new Array();
            var markers_'.$this->map_name.' = new Array();
            var iw_'.$this->map_name.';
            var geocoder; // Global declaration of geocoder for reverser location from latLng
            ';
        if ($this->cluster) {
            $this->output_js_contents .= 'var markerCluster;
            ';
        }
        if ($this->directions) {
            $rendererOptions = '';
            if ($this->directionsDraggable) {
                $this->output_js_contents .= '
            var rendererOptions = { draggable: true };
            ';
                $rendererOptions = 'rendererOptions';
            }
            $this->output_js_contents .= 'var directionsDisplay = new google.maps.DirectionsRenderer('.$rendererOptions.');
            var directionsService = new google.maps.DirectionsService();
            ';
        }
        if ($this->places) {
            $this->output_js_contents .= 'var placesService;
            ';
            if ($this->placesAutocompleteInputID != "") {
                $this->output_js_contents .= 'var placesAutocomplete;
            ';
            }
        }
        if ($this->adsense) {
            $this->output_js_contents .= 'var adUnit;
            ';
        }
        if ($this->drawing) {
            $this->output_js_contents .= 'var drawingManager;
            ';
        }

        /*$this->output_js_contents .= '
            iw_'.$this->map_name.' = new google.maps.InfoWindow(';
        if ($this->infowindowMaxWidth != 0) {
            $this->output_js_contents .= '{
                maxWidth: '.$this->infowindowMaxWidth.'
            }';
        }
        $this->output_js_contents .= ');

                 ';*/

        $this->output_js_contents .= 'function initialize_'.$this->map_name.'() {

                ';

        $styleOutput = '';
        if (count($this->styles)) {
            $styles = 0;
            foreach ($this->styles as $style) {
                $this->output_js_contents .= 'var styles_'.$styles.' = '.json_encode($style['definition']).';
                ';

                if ($this->stylesAsMapTypes) {
                    $this->output_js_contents .= 'var styles_'.$styles.' = new google.maps.StyledMapType(styles_'.$styles.', {name:"'.$style['name'].'"});
                ';
                } else {
                    $styleOutput .= $this->map_name.'.setOptions({styles: styles_'.$styles.'});
                ';
                    break;
                }

                ++$styles;
            }
        }

        if ($this->center != "auto") {
            if ($this->is_lat_long($this->center)) { // if centering the map on a lat/long
                $this->output_js_contents .= 'var myLatlng = new google.maps.LatLng('.$this->center.');';
            } else {  // if centering the map on an address
                $lat_long = $this->get_lat_long_from_address($this->center);
                $this->output_js_contents .= 'var myLatlng = new google.maps.LatLng('.$lat_long[0].', '.$lat_long[1].');';
            }
        }

        $this->output_js_contents .= '
            iw_'.$this->map_name.' = new google.maps.InfoWindow(';
        if ($this->infowindowMaxWidth != 0) {
            $this->output_js_contents .= '{
                maxWidth: '.$this->infowindowMaxWidth.'
            }';
        }
        $this->output_js_contents .= ');

                 ';

        $this->output_js_contents .= '
                var myOptions = {
                    ';
        if ($this->zoom == "auto") {
            $this->output_js_contents .= 'zoom: 13,';
        } else {
            $this->output_js_contents .= 'zoom: '.$this->zoom.',';
        }
        if ($this->center != "auto") {
            $this->output_js_contents .= '
                    center: myLatlng,';
        }
        if (strtolower($this->map_type) == "street") {
            $map_type = "ROADMAP";
        } else {
            $map_type = $this->map_type;
        }
        $this->output_js_contents .= '
                    mapTypeId: google.maps.MapTypeId.'.$map_type;
        if ($this->backgroundColor) {
            $this->output_js_contents .= ',
                    backgroundColor: \''.$this->backgroundColor.'\'';
        }
        if ($this->disableDefaultUI) {
            $this->output_js_contents .= ',
                    disableDefaultUI: true';
        }
        if ($this->disableMapTypeControl) {
            $this->output_js_contents .= ',
                    mapTypeControl: false';
        }
        if ($this->disableNavigationControl) {
            $this->output_js_contents .= ',
                    navigationControl: false';
        }
        if ($this->disableScaleControl) {
            $this->output_js_contents .= ',
                    scaleControl: false';
        }
        if ($this->disableStreetViewControl) {
            $this->output_js_contents .= ',
                    streetViewControl: false';
        }
        //Added for full screen control
         if ($this->enableFullScreenControl) {
            $this->output_js_contents .= ',
                    fullscreenControl: true';
        }
        if ($this->disableDoubleClickZoom) {
            $this->output_js_contents .= ',
                    disableDoubleClickZoom: true';
        }
        if (!$this->draggable) {
            $this->output_js_contents .= ',
                    draggable: false';
        }
        if ($this->draggableCursor != "") {
            $this->output_js_contents .= ',
                    draggableCursor: "'.$this->draggableCursor.'"';
        }
        if ($this->draggingCursor != "") {
            $this->output_js_contents .= ',
                    draggingCursor: "'.$this->draggingCursor.'"';
        }
        if (!$this->keyboardShortcuts) {
            $this->output_js_contents .= ',
                    keyboardShortcuts: false';
        }
        $mapTypeControlOptions = array();
        $map_types = array();
        if ($this->mapTypeControlPosition != "") {
            array_push($mapTypeControlOptions, 'position: google.maps.ControlPosition.'.strtoupper($this->mapTypeControlPosition));
        }
        if ($this->mapTypeControlStyle != "" && (strtoupper($this->mapTypeControlStyle) == "DROPDOWN_MENU" || strtoupper($this->mapTypeControlStyle) == "HORIZONTAL_BAR")) {
            array_push($mapTypeControlOptions, 'style: google.maps.MapTypeControlStyle.'.strtoupper($this->mapTypeControlStyle));
        }
        if (count($this->map_types_available)) {
            foreach ($this->map_types_available as $map_type) {
                array_push($map_types, 'google.maps.MapTypeId.'.strtoupper($map_type));
            }
        }
        if (count($this->styles) && $this->stylesAsMapTypes) {
            $styles = 0;
            foreach ($this->styles as $style) {
                array_push($map_types, '"style'.$styles.'"');
                $styleOutput .= '
                      '.$this->map_name.'.mapTypes.set("style'.$styles.'", styles_'.$styles.');
                ';
                if ($this->stylesAsMapTypesDefault == $style['name']) {
                    $styleOutput .= '
                      '.$this->map_name.'.setMapTypeId("style'.$styles.'");
                ';
                }
                $styles++;
            }
        }
        if (count($map_types)) {
            array_push($mapTypeControlOptions, 'mapTypeIds: ['.implode(", ", $map_types).']');
        }
        if (count($mapTypeControlOptions)) {
            $this->output_js_contents .= ',
                    mapTypeControlOptions: {'.implode(",", $mapTypeControlOptions).'}';
        }
        if ($this->minzoom != "") {
            $this->output_js_contents .= ',
                    minZoom: '.$this->minzoom;
        }
        if ($this->maxzoom != "") {
            $this->output_js_contents .= ',
                    maxZoom: '.$this->maxzoom;
        }
        if ($this->noClear) {
            $this->output_js_contents .= ',
                    noClear: true';
        }
        if ($this->navigationControlPosition != "") {
            $this->output_js_contents .= ',
                    navigationControlOptions: {position: google.maps.ControlPosition.'.strtoupper($this->navigationControlPosition).'}';
        }
        if ($this->scaleControlPosition != "") {
            $this->output_js_contents .= ',
                     scaleControl: true,
                    scaleControlOptions: {position: google.maps.ControlPosition.'.strtoupper($this->scaleControlPosition).'}';
        }
        if (!$this->scrollwheel) {
            $this->output_js_contents .= ',
                    scrollwheel: false';
        }
        if ($this->streetViewControlPosition != "") {
            $this->output_js_contents .= ',
                    streetViewControlOptions: {position: google.maps.ControlPosition.'.strtoupper($this->streetViewControlPosition).'}';
        }
        if ($this->tilt == 45) {
            $this->output_js_contents .= ',
                    tilt: '.$this->tilt;
        }
        $zoomControlOptions = array();
        if ($this->zoomControlPosition != "") {
            array_push($zoomControlOptions, 'position: google.maps.ControlPosition.'.strtoupper($this->zoomControlPosition));
        }
        if ($this->zoomControlStyle != "" && (strtoupper($this->zoomControlStyle) == "SMALL" || strtoupper($this->zoomControlStyle) == "LARGE")) {
            array_push($zoomControlOptions, 'style: google.maps.ZoomControlStyle.'.strtoupper($this->zoomControlStyle));
        }
        if (count($zoomControlOptions)) {
            $this->output_js_contents .= ',
                    zoomControlOptions: {'.implode(",", $zoomControlOptions).'}';
        }


        $this->output_js_contents .= '};';

        $this->output_js_contents .=$this->map_name.' = new google.maps.Map(document.getElementById("'.$this->map_div_id.'"), myOptions);';

        /* Map Custom Controls */
        foreach($this->injectControlsInTopLeft as $customControl){
            $this->output_js_contents .= $this->map_name.'.controls[google.maps.ControlPosition.TOP_LEFT].push('. $customControl .');';
        }

        foreach($this->injectControlsInTopCenter as $customControl){
            $this->output_js_contents .= $this->map_name.'.controls[google.maps.ControlPosition.TOP_CENTER].push('. $customControl .');';
        }

        foreach($this->injectControlsInTopRight as $customControl){
            $this->output_js_contents .= $this->map_name.'.controls[google.maps.ControlPosition.TOP_RIGHT].push('. $customControl .');';
        }

        foreach($this->injectControlsInLeftTop as $customControl){
            $this->output_js_contents .= $this->map_name.'.controls[google.maps.ControlPosition.LEFT_TOP].push('. $customControl .');';
        }

        foreach($this->injectControlsInLeftCenter as $customControl){
            $this->output_js_contents .= $this->map_name.'.controls[google.maps.ControlPosition.LEFT_CENTER].push('. $customControl .');';
        }

        foreach($this->injectControlsInLeftBottom as $customControl){
            $this->output_js_contents .= $this->map_name.'.controls[google.maps.ControlPosition.LEFT_BOTTOM].push('. $customControl .');';
        }

        foreach($this->injectControlsInBottomLeft as $customControl){
            $this->output_js_contents .= $this->map_name.'.controls[google.maps.ControlPosition.BOTTOM_LEFT].push('. $customControl .');';
        }

        foreach($this->injectControlsInBottomCenter as $customControl){
            $this->output_js_contents .= $this->map_name.'.controls[google.maps.ControlPosition.BOTTOM_CENTER].push('. $customControl .');';
        }

        foreach($this->injectControlsInBottomRight as $customControl){
            $this->output_js_contents .= $this->map_name.'.controls[google.maps.ControlPosition.BOTTOM_RIGHT].push('. $customControl .');';
        }

        foreach($this->injectControlsInRightTop as $customControl){
            $this->output_js_contents .= $this->map_name.'.controls[google.maps.ControlPosition.RIGHT_TOP].push('. $customControl .');';
        }

        foreach($this->injectControlsInRightCenter as $customControl){
            $this->output_js_contents .= $this->map_name.'.controls[google.maps.ControlPosition.RIGHT_CENTER].push('. $customControl .');';
        }

        foreach($this->injectControlsInRightBottom as $customControl){
            $this->output_js_contents .= $this->map_name.'.controls[google.maps.ControlPosition.RIGHT_BOTTOM].push('. $customControl .');';
        }
        /* End Map Custom Controls */

        /* map on staged event */
        if($this->onstaged != ''){
            $this->output_js_contents .= '
            //user callback
                onstaged_'. $this->map_name .'();
            ';
        }

        /* Reverse Geocoding */
        $this->output_js_contents .= 'geocoder = new google.maps.Geocoder;';

        /* End reverse Geocoding */

        if ($styleOutput != "") {
            $this->output_js_contents .= $styleOutput.'
                ';
        }

        if ($this->trafficOverlay) {
            $this->output_js_contents .= 'var trafficLayer = new google.maps.TrafficLayer();
                trafficLayer.setMap('.$this->map_name.');
                ';
        }
        if ($this->bicyclingOverlay) {
            $this->output_js_contents .= 'var bikeLayer = new google.maps.BicyclingLayer();
                bikeLayer.setMap('.$this->map_name.');
                ';
        }

        if ((is_array($this->kmlLayerURL) && count($this->kmlLayerURL)) || (!is_array($this->kmlLayerURL) && $this->kmlLayerURL != "")) {
            if (!is_array($this->kmlLayerURL)) {
                // Need to convert single KML layer to array
                $this->kmlLayerURL = array($this->kmlLayerURL);
            }
            if (count($this->kmlLayerURL)) {
                $i = 0;
                foreach ($this->kmlLayerURL as $kmlLayerURL) {
                    $this->output_js_contents .= '
                        var kmlLayerOptions = {
                            map: '.$this->map_name;
                    if ($this->kmlLayerPreserveViewport) {
                        $this->output_js_contents .= ',
                            preserveViewport: true';
                    }
                    $this->output_js_contents .= '
                        }
                        var kmlLayer_'.$i.' = new google.maps.KmlLayer("'.$kmlLayerURL.'", kmlLayerOptions);
                        ';
                    ++$i;
                }
            }
        }

        if ($this->panoramio) {
            $this->output_js_contents .= 'var panoramioLayer = new google.maps.panoramio.PanoramioLayer();
                ';
            if ($this->panoramioTag != "") {
                $this->output_js_contents .= 'panoramioLayer.setTag("'.$this->panoramioTag.'");
                ';
            }
            if ($this->panoramioUser != "") {
                $this->output_js_contents .= 'panoramioLayer.setUserId("'.$this->panoramioUser.'");
                ';
            }
            $this->output_js_contents .= '
                panoramioLayer.setMap('.$this->map_name.');
                ';
        }

        if (strtolower($this->map_type) == "street") { // if defaulting the map to Street View
            $this->output_js_contents .= '
                var streetViewOptions = {
                    position: myLatlng';
            if (!$this->streetViewAddressControl) {
                $this->output_js_contents .= ',
                    addressControl: false';
            }
            if ($this->streetViewAddressPosition != "") {
                $this->output_js_contents .= ',
                    addressControlOptions: { position: google.maps.ControlPosition.'.$this->streetViewAddressPosition.' }';
            }
            if ($this->streetViewCloseButton) {
                $this->output_js_contents .= ',
                    enableCloseButton: true';
            }
            if (!$this->streetViewLinksControl) {
                $this->output_js_contents .= ',
                    linksControl: false';
            }
            if (!$this->streetViewPanControl) {
                $this->output_js_contents .= ',
                    panControl: false';
            }
            if ($this->streetViewPanPosition != "") {
                $this->output_js_contents .= ',
                    panControlOptions: { position: google.maps.ControlPosition.'.$this->streetViewPanPosition.' }';
            }
            if ($this->streetViewPovHeading != 0 || $this->streetViewPovPitch != 0 || $this->streetViewPovZoom != 0) {
                $this->output_js_contents .= ',
                    pov: {
                        heading: '.$this->streetViewPovHeading.',
                        pitch: '.$this->streetViewPovPitch.',
                        zoom: '.$this->streetViewPovZoom.'
                    }';
            }
            if (!$this->streetViewZoomControl) {
                $this->output_js_contents .= ',
                    zoomControl: false';
            }
            if ($this->streetViewZoomPosition != "" || $this->streetViewZoomStyle != "") {
                $this->output_js_contents .= ',
                    zoomControlOptions: {';
                if ($this->streetViewZoomPosition != "") {
                    $this->output_js_contents .= '
                        position: google.maps.ControlPosition.'.$this->streetViewZoomPosition.',';
                }
                if ($this->streetViewZoomStyle != "") {
                    $this->output_js_contents .= '
                        style: google.maps.ZoomControlStyle.'.$this->streetViewZoomStyle.',';
                }
                $this->output_js_contents = trim($this->output_js_contents, ",");
                $this->output_js_contents .= '}';
            }
            $this->output_js_contents .= '
                };
                var streetView = new google.maps.StreetViewPanorama(document.getElementById("'.$this->map_div_id.'"), streetViewOptions);
                streetView.setVisible(true);
                ';
        }

        if ($this->center == "auto") { // if wanting to center on the users location
            $this->output_js_contents .= '
                // Try W3C Geolocation (Preferred)
                if(navigator.geolocation) {
                    navigator.geolocation.getCurrentPosition(function(position) {
                        '.$this->map_name.'.setCenter(new google.maps.LatLng(position.coords.latitude,position.coords.longitude));
                    }, function() { alert("Unable to get your current position. Please try again. Geolocation service failed."); });
                // Browser doesn\'t support Geolocation
                }else{
                    alert(\'Your browser does not support geolocation.\');
                }
            ';
        }

        if ($this->directions) {
            $this->output_js_contents .= 'directionsDisplay.setMap('.$this->map_name.');
            ';
            if ($this->directionsDivID != "") {
                $this->output_js_contents .= 'directionsDisplay.setPanel(document.getElementById("'.$this->directionsDivID.'"));
            ';
            }
            if ($this->directionsDraggable && $this->directionsChanged != "") {
                $this->output_js_contents .= 'google.maps.event.addListener(directionsDisplay, "directions_changed", function() {
                    '.$this->directionsChanged.'
                });
            ';
            }
        }

        if ($this->drawing) {
            if ($this->drawingControlPosition == '') {
                $this->drawingControlPosition = 'TOP_CENTER';
            }

            $this->output_js_contents .= 'drawingManager = new google.maps.drawing.DrawingManager({
                drawingMode: google.maps.drawing.OverlayType.'.strtoupper($this->drawingDefaultMode).',
                drawingControl: '.(!$this->drawingControl ? 'false' : 'true').',
                drawingControlOptions: {
                    position: google.maps.ControlPosition.'.strtoupper($this->drawingControlPosition);
            $shapeOptions = '';
            if (count($this->drawingModes)) {
                $this->output_js_contents .= ',
                    drawingModes: [';
                $i = 0;
                foreach ($this->drawingModes as $drawingMode) {
                    if ($i > 0) {
                        $this->output_js_contents .= ',';
                    }
                    $this->output_js_contents .= 'google.maps.drawing.OverlayType.'.strtoupper($drawingMode);
                    if (strtoupper($drawingMode) != "MARKER") {
                        $shapeOptions .= ',
                        '.strtolower($drawingMode).'Options: {
                            editable: true
                        }';
                    }
                    $i++;
                }
                $this->output_js_contents .= ']';
            }
            $this->output_js_contents .= '
                }'.$shapeOptions.'
            });
            drawingManager.setMap('.$this->map_name.');
            ';

            $this->output_js_contents .= '
            google.maps.event.addListener(drawingManager, "overlaycomplete", function(event) {
                var newShape = event.overlay;
                newShape.type = event.type;
                ';
            if (count($this->drawingOnComplete)) {
                foreach ($this->drawingOnComplete as $shape => $js) {
                    $this->output_js_contents .= 'if (event.type==google.maps.drawing.OverlayType.'.strtoupper($shape).') {
                        '.$js.'
                    }
                    ';
                }
            }

            if (count($this->drawingOnEdit)) {
                if (isset($this->drawingOnEdit['polygon'])) {
                    $this->output_js_contents .= '
                if (newShape.type==google.maps.drawing.OverlayType.POLYGON) {
                    var newShapePaths = newShape.getPaths();
                    for (var i=0; i<newShapePaths.length; i++) {
                        google.maps.event.addListener(newShapePaths.getAt(i), "set_at", function(event) {
                            '.$this->drawingOnEdit['polygon'].'
                        });
                        google.maps.event.addListener(newShapePaths.getAt(i), "insert_at", function(event) {
                            '.$this->drawingOnEdit['polygon'].'
                        });
                        google.maps.event.addListener(newShapePaths.getAt(i), "remove_at", function(event) {
                            '.$this->drawingOnEdit['polygon'].'
                        });
                    }
                }';
                }
                if (isset($this->drawingOnEdit['polyline'])) {
                    $this->output_js_contents .= '
                if (newShape.type==google.maps.drawing.OverlayType.POLYLINE) {
                    var newShapePaths = newShape.getPaths();
                    for (var i=0; i<newShapePaths.length; i++) {
                        google.maps.event.addListener(newShapePaths.getAt(i), "set_at", function(event) {
                            '.$this->drawingOnEdit['polyline'].'
                        });
                        google.maps.event.addListener(newShapePaths.getAt(i), "insert_at", function(event) {
                            '.$this->drawingOnEdit['polyline'].'
                        });
                        google.maps.event.addListener(newShapePaths.getAt(i), "remove_at", function(event) {
                            '.$this->drawingOnEdit['polyline'].'
                        });
                    }
                }';
                }
                if (isset($this->drawingOnEdit['rectangle'])) {
                    $this->output_js_contents .= '
                if (newShape.type==google.maps.drawing.OverlayType.RECTANGLE) {
                    google.maps.event.addListener(newShape, "bounds_changed", function(event) {
                        '.$this->drawingOnEdit['rectangle'].'
                    });
                }';
                }
                if (isset($this->drawingOnEdit['circle'])) {
                    $this->output_js_contents .= '
                if (newShape.type==google.maps.drawing.OverlayType.CIRCLE) {
                    google.maps.event.addListener(newShape, "radius_changed", function(event) {
                        '.$this->drawingOnEdit['circle'].'
                    });
                    google.maps.event.addListener(newShape, "center_changed", function(event) {
                        '.$this->drawingOnEdit['circle'].'
                    });
                }';
                }
            }

            $this->output_js_contents .= '
            });';
        }

        if ($this->places) {
            $placesLocationSet = false;

            if ($this->placesLocationSW != "" && $this->placesLocationNE != "") { // if search based on bounds

                $placesLocationSet = true;

                if ($this->is_lat_long($this->placesLocationSW)) {
                    $this->output_js_contents .= 'var placesLocationSW = new google.maps.LatLng('.$this->placesLocationSW.');
            ';
                } else {  // if centering the map on an address
                    $lat_long = $this->get_lat_long_from_address($this->placesLocationSW);
                    $this->output_js_contents .= 'var placesLocationSW = new google.maps.LatLng('.$lat_long[0].', '.$lat_long[1].');
            ';
                }

                if ($this->is_lat_long($this->placesLocationNE)) {
                    $this->output_js_contents .= 'var placesLocationNE = new google.maps.LatLng('.$this->placesLocationNE.');
            ';
                } else {  // if centering the map on an address
                    $lat_long = $this->get_lat_long_from_address($this->placesLocationNE);
                    $this->output_js_contents .= 'var placesLocationNE = new google.maps.LatLng('.$lat_long[0].', '.$lat_long[1].');
            ';
                }
            }

            if (($placesLocationSet || $this->placesLocation != "") || count($this->placesTypes) || $this->placesName != "") {
                $this->output_js_contents .= 'var placesRequest = {
                    ';
                if ($placesLocationSet) {
                    $this->output_js_contents .= 'bounds: new google.maps.LatLngBounds(placesLocationSW, placesLocationNE)
                        ';
                } else {
                    if ($this->placesLocation != "") { // if search based on a center point
                        if ($this->is_lat_long($this->placesLocation)) { // if centering the map on a lat/long
                            $this->output_js_contents .= 'location: new google.maps.LatLng('.$this->placesLocation.')
                        ';
                        } else {  // if centering the map on an address
                            $lat_long = $this->get_lat_long_from_address($this->placesLocation);
                            $this->output_js_contents .= 'location: new google.maps.LatLng('.$lat_long[0].', '.$lat_long[1].')
                        ';
                        }
                        $this->output_js_contents .= ',radius: '.$this->placesRadius.'
                        ';
                    }
                }

                if (count($this->placesTypes)) {
                    $this->output_js_contents .= ',types: [\''.implode("','", $this->placesTypes).'\']
                        ';
                }
                if ($this->placesName != "") {
                    $this->output_js_contents .= ',name : \''.$this->placesName.'\'
                        ';
                }
                $this->output_js_contents .= '};

                placesService = new google.maps.places.PlacesService('.$this->map_name.');
                placesService.search(placesRequest, placesCallback);
                ';
            }

            if ($this->placesAutocompleteInputID != "") {
                $this->output_js_contents .= 'var autocompleteOptions = {
                    ';
                $autocompleteOptions = '';
                if ($this->placesAutocompleteBoundSW != "" && $this->placesAutocompleteBoundNE != "") {
                    if ($this->is_lat_long($this->placesAutocompleteBoundSW)) {
                        $autocompleteOptionsSW = 'new google.maps.LatLng('.$this->placesAutocompleteBoundSW.')
                    ';
                    } else {  // if centering the map on an address
                        $lat_long = $this->get_lat_long_from_address($this->placesAutocompleteBoundSW);
                        $autocompleteOptionsSW = 'new google.maps.LatLng('.$lat_long[0].', '.$lat_long[1].')
                    ';
                    }

                    if ($this->is_lat_long($this->placesAutocompleteBoundNE)) {
                        $autocompleteOptionsNE = 'new google.maps.LatLng('.$this->placesAutocompleteBoundNE.')
                    ';
                    } else {  // if centering the map on an address
                        $lat_long = $this->get_lat_long_from_address($this->placesAutocompleteBoundNE);
                        $autocompleteOptionsNE = 'new google.maps.LatLng('.$lat_long[0].', '.$lat_long[1].')
                    ';
                    }
                    $autocompleteOptions .= 'bounds: new google.maps.LatLngBounds('.$autocompleteOptionsSW.', '.$autocompleteOptionsNE.')';
                }
                if (count($this->placesAutocompleteTypes)) {
                    if ($autocompleteOptions != "") {
                        $autocompleteOptions .= ',
                         ';
                    }
                    $autocompleteOptions .= 'types: [\''.implode("','", $this->placesAutocompleteTypes).'\']';
                }
                $this->output_js_contents .= $autocompleteOptions;
                $this->output_js_contents .= '}';

                $this->output_js_contents .= '
                var autocompleteInput = document.getElementById(\''.$this->placesAutocompleteInputID.'\');

                placesAutocomplete = new google.maps.places.Autocomplete(autocompleteInput, autocompleteOptions);
                ';

                if ($this->placesAutocompleteBoundsMap) {
                    $this->output_js_contents .= 'placesAutocomplete.bindTo(\'bounds\', map);
                    ';
                }

                if ($this->placesAutocompleteOnChange != "") {
                    $this->output_js_contents .= 'google.maps.event.addListener(placesAutocomplete, \'place_changed\', function() {
                        var place = placesAutocomplete.getPlace();
                        if (!place.geometry) {
                          '. $this->palcesAutoCompleteOnChangeFailed .'
                          return;
                        }

                        if (place.geometry.viewport) {
                          '. $this->map_name .'.fitBounds(place.geometry.viewport);
                        } else {
                          '. $this->map_name .'.setCenter(place.geometry.location);
                          '. $this->map_name .'.setZoom('. $this->zoom .');
                        }

                        event = {latLng: place.geometry.location}

                        '. $this->placesAutocompleteOnChange .'
                    });
                    ';
                }
            }
        }

        if ($this->onboundschanged != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "bounds_changed", function(event) {

                '.$this->onboundschanged.'
            });
            ';
        }
        if ($this->oncenterchanged != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "center_changed", function(event) {
                '.$this->oncenterchanged.'
            });
            ';
        }
        if ($this->onclick != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "click", function(event) {
                '.$this->onclick.'
            });
            ';
        }
        if ($this->ondblclick != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "dblclick", function(event) {
                '.$this->ondblclick.'
            });
            ';
        }
        if ($this->ondrag != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "drag", function(event) {
                '.$this->ondrag.'
            });
            ';
        }
        if ($this->ondragend != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "dragend", function(event) {
                '.$this->ondragend.'
            });
            ';
        }
        if ($this->ondragstart != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "dragstart", function(event) {
                '.$this->ondragstart.'
            });
            ';
        }
        if ($this->onidle != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "idle", function(event) {
                '.$this->onidle.'
            });
            ';
        }
        if ($this->onmousemove != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "mousemove", function(event) {
                '.$this->onmousemove.'
            });
            ';
        }
        if ($this->onmouseout != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "mouseout", function(event) {
                '.$this->onmouseout.'
            });
            ';
        }
        if ($this->onmouseover != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "mouseover", function(event) {
                '.$this->onmouseover.'
            });
            ';
        }
        if ($this->onresize != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "resize", function(event) {
                '.$this->onresize.'
            });
            ';
        }
        if ($this->onrightclick != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "rightclick", function(event) {
                '.$this->onrightclick.'
            });
            ';
        }
        if ($this->ontilesloaded != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "tilesloaded", function(event) {
                '.$this->ontilesloaded.'
            });
            ';
        }
        if ($this->onzoomchanged != "") {
            $this->output_js_contents .= 'google.maps.event.addListener('.$this->map_name.', "zoom_changed", function(event) {
                '.$this->onzoomchanged.'
            });
            ';
        }



        // add markers
        if (count($this->markers)) {
            foreach ($this->markers as $marker) {
                $this->output_js_contents .= $marker;
            }
        }
        //

        if ($this->cluster) {
            $this->output_js_contents .= '
            var clusterOptions = {
                gridSize: '.$this->clusterGridSize;
            if ($this->clusterMaxZoom != "") {
                $this->output_js_contents .= ',
                maxZoom: '.$this->clusterMaxZoom;
            }
            if (!$this->clusterZoomOnClick) {
                $this->output_js_contents .= ',
                zoomOnClick: false';
            }
            if ($this->clusterAverageCenter) {
                $this->output_js_contents .= ',
                averageCenter: true';
            }
            if (count($this->clusterStyles) > 0) {

                $this->output_js_contents .= ',
                styles: [ ';
                $styleOutput = [];
                foreach($this->clusterStyles as $clusterStyle){
                    $attributes =[];
                    foreach($clusterStyle as $key => $style){
                        $attributes[] = $key.':"'.$style.'"';
                    }
                    $styleOutput[] = '{'.implode(',',$attributes).'}';
                }
                $this->output_js_contents .= implode(',',$styleOutput);
                $this->output_js_contents .= ']';
            }

            $this->output_js_contents .= ',
                minimumClusterSize: '.$this->clusterMinimumClusterSize.'
            };
            markerCluster = new MarkerClusterer('.$this->map_name.', markers_'.$this->map_name.', clusterOptions);
            ';
        }

        // add polylines
        if (count($this->polylines)) {
            foreach ($this->polylines as $polyline) {
                $this->output_js_contents .= $polyline;
            }
        }
        //

        // add polygons
        if (count($this->polygons)) {
            foreach ($this->polygons as $polygon) {
                $this->output_js_contents .= $polygon;
            }
        }
        //

        // add circles
        if (count($this->circles)) {
            foreach ($this->circles as $circle) {
                $this->output_js_contents .= $circle;
            }
        }
        //

        // add rectangles
        if (count($this->rectangles)) {
            foreach ($this->rectangles as $rectangle) {
                $this->output_js_contents .= $rectangle;
            }
        }
        //

        // add ground overlays
        if (count($this->overlays)) {
            foreach ($this->overlays as $overlay) {
                $this->output_js_contents .= $overlay;
            }
        }
        //

        if ($this->zoom == "auto") {
            $this->output_js_contents .= '
            fitMapToBounds_'.$this->map_name.'();
            ';
        }

        if ($this->adsense) {
            $this->output_js_contents .= '
            var adUnitDiv = document.createElement("div");

            // Note: replace the publisher ID noted here with your own
            // publisher ID.
            var adUnitOptions = {
                format: google.maps.adsense.AdFormat.'.$this->adsenseFormat.',
                position: google.maps.ControlPosition.'.$this->adsensePosition.',
                publisherId: "'.$this->adsensePublisherID.'",
                ';
            if ($this->adsenseChannelNumber != "") {
                $this->output_js_contents .= 'channelNumber: "'.$this->adsenseChannelNumber.'",
                ';
            }
            $this->output_js_contents .= 'map: '.$this->map_name.',
                visible: true
            };
            adUnit = new google.maps.adsense.AdUnit(adUnitDiv, adUnitOptions);
            ';
        }

        if ($this->directions && $this->directionsStart != "" && $this->directionsEnd != "") {
            if ($this->directionsStart == "auto" && $this->directionsEnd == "auto") {
                // Both start and finish are at the users current location
                $this->output_js_contents .= '
                // Try W3C Geolocation (Preferred)
                if(navigator.geolocation) {
                    navigator.geolocation.getCurrentPosition(function(position) {
                        start = position.coords.latitude+","+position.coords.longitude;
                        calcRoute(start, start);
                    }, function() { alert("Unable to get your current position. Please try again. Geolocation service failed."); });
                // Browser doesn\'t support Geolocation
                }else{
                    alert(\'Your browser does not support geolocation.\');
                }
                ';
            } elseif ($this->directionsStart == "auto") {
                // The start point should be at the users current location
                $this->output_js_contents .= '
                // Try W3C Geolocation (Preferred)
                if(navigator.geolocation) {
                    navigator.geolocation.getCurrentPosition(function(position) {
                        start = position.coords.latitude+","+position.coords.longitude;
                        calcRoute(start, \''.$this->directionsEnd.'\');
                    }, function() { alert("Unable to get your current position. Please try again. Geolocation service failed."); });
                // Browser doesn\'t support Geolocation
                }else{
                    alert(\'Your browser does not support geolocation.\');
                }
                ';
            } elseif ($this->directionsEnd == "auto") {
                // The end point should be at the users current location
                $this->output_js_contents .= '
                // Try W3C Geolocation (Preferred)
                if(navigator.geolocation) {
                    navigator.geolocation.getCurrentPosition(function(position) {
                        end = position.coords.latitude+","+position.coords.longitude;
                        calcRoute(\''.$this->directionsStart.'\', end);
                    }, function() { alert("Unable to get your current position. Please try again. Geolocation service failed."); });
                // Browser doesn\'t support Geolocation
                }else{
                    alert(\'Your browser does not support geolocation.\');
                }
                ';
            } else {
                // The start and end point are at pre-defined locations
                $this->output_js_contents .= '
                calcRoute(\''.$this->directionsStart.'\', \''.$this->directionsEnd.'\');
                ';
            }
        }

        if ($this->onload != "") {
            $this->output_js_contents .= '
                '.$this->onload;
        }

        $this->output_js_contents .= '
            }

        ';

        /* onStaged map */
        $this->output_js_contents .= '
        function onstaged_'. $this->map_name .'(){';

        if($this->onstaged != '')
            $this->output_js_contents .= $this->onstaged.'();';

        $this->output_js_contents .= '}
        ';

        // add markers
        $this->output_js_contents .= '
        function createMarker_'.$this->map_name.'(markerOptions) {
            var marker = new google.maps.Marker(markerOptions);
            markers_'.$this->map_name.'.push(marker);
            lat_longs_'.$this->map_name.'.push(marker.getPosition());
            return marker;
        }
        ';
        //

        if ($this->directions) {
            $this->output_js_contents .= 'function calcRoute(start, end) {

            var request = {
                    origin:start,
                    destination:end,
                    travelMode: google.maps.TravelMode.'.$this->directionsMode.'
                    ';

            if (count($this->directionsWaypointArray)) {
                $directionsWaypointStr = '';
                foreach ($this->directionsWaypointArray as $waypoint) {
                    if ($directionsWaypointStr != '') {
                        $directionsWaypointStr .= ',';
                    }
                    $directionsWaypointStr .= '{ location: "'.$waypoint.'", stopover: true}';
                }
                $this->output_js_contents .= ', waypoints: ['.$directionsWaypointStr.']';

                if ($this->directionsWaypointsOptimize) {
                    $this->output_js_contents .= ', optimizeWaypoints: true';
                }
            }
            if ($this->region != "" && strlen($this->region) == 2) {
                $this->output_js_contents .= ',region: '.strtoupper($this->region).'
                    ';
            }
            if (trim($this->directionsUnits) != "" && (strtolower(trim($this->directionsUnits)) == "metric" || strtolower(trim($this->directionsUnits)) == "imperial")) {
                $this->output_js_contents .= ',unitSystem: google.maps.UnitSystem.'.strtoupper(trim($this->directionsUnits)).'
                    ';
            }
            if ($this->directionsAvoidTolls) {
                $this->output_js_contents .= ',avoidTolls: true
                    ';
            }
            if ($this->directionsAvoidHighways) {
                $this->output_js_contents .= ',avoidHighways: true
                    ';
            }

            $this->output_js_contents .= '
            };
                directionsService.route(request, function(response, status) {
                    if (status == google.maps.DirectionsStatus.OK) {
                        directionsDisplay.setDirections(response);
                    }else{
                        switch (status) {
                            case "NOT_FOUND": { alert("Either the start location or destination were not recognised"); break }
                            case "ZERO_RESULTS": { alert("No route could be found between the start location and destination"); break }
                            case "MAX_WAYPOINTS_EXCEEDED": { alert("Maximum waypoints exceeded. Maximum of 8 allowed"); break }
                            case "INVALID_REQUEST": { alert("Invalid request made for obtaining directions"); break }
                            case "OVER_QUERY_LIMIT": { alert("This webpage has sent too many requests recently. Please try again later"); break }
                            case "REQUEST_DENIED": { alert("This webpage is not allowed to request directions"); break }
                            case "UNKNOWN_ERROR": { alert("Unknown error with the server. Please try again later"); break }
                        }
                    }
                });
            }
            ';
        }

        if ($this->places) {
            $this->output_js_contents .= 'function placesCallback(results, status) {
                if (status == google.maps.places.PlacesServiceStatus.OK) {
                    for (var i = 0; i < results.length; i++) {

                        var place = results[i];

                        var placeLoc = place.geometry.location;
                        var placePosition = new google.maps.LatLng(placeLoc.lat(), placeLoc.lng());
                        var markerOptions = {
                            map: '.$this->map_name.',
                            position: placePosition
                        };
                        var marker = createMarker_'.$this->map_name.'(markerOptions);
                        marker.set("content", place.name);
                        google.maps.event.addListener(marker, "click", function() {
                            iw_'.$this->map_name.'.setContent(this.get("content"));
                            iw_'.$this->map_name.'.open('.$this->map_name.', this);
                        });

                        lat_longs_'.$this->map_name.'.push(placePosition);

                    }
                    ';
            if ($this->zoom == "auto") {
                $this->output_js_contents .= 'fitMapToBounds_'.$this->map_name.'();';
            }
            $this->output_js_contents .= '
                }
            }
            ';
        }

        if ($this->zoom == "auto") {
            $this->output_js_contents .= '
            function fitMapToBounds_'.$this->map_name.'() {
                var bounds = new google.maps.LatLngBounds();
                if (lat_longs_'.$this->map_name.'.length>0) {
                    for (var i=0; i<lat_longs_'.$this->map_name.'.length; i++) {
                        bounds.extend(lat_longs_'.$this->map_name.'[i]);
                    }
                    '.$this->map_name.'.fitBounds(bounds);
                }
            }
            ';
        }

        if ($this->loadAsynchronously) {
            $this->output_js_contents .= '
            function loadScript_'.$this->map_name.'() {
                var script = document.createElement("script");
                script.type = "text/javascript";
                script.src = "'.$apiLocation.'&callback=initialize_'.$this->map_name.'";
                document.body.appendChild(script);
            }
            window.onload = loadScript_'.$this->map_name.';
            ';
        } else {
            $this->output_js_contents .= '
            google.maps.event.addDomListener(window, "load", initialize_'.$this->map_name.');
            ';
        }

        /* Geocoding reverse method */
        //If return false, no result found.
        //If return object, error in query and error bag return in object
        //If string will return, result OK
        $this->output_js_contents .= '
        function reverseGeocode(latlng, callback, obj) { //callback must be function
          //var latlng = {lat: parseFloat(latitude), lng: parseFloat(longitude)};
          geocoder.geocode({\'location\': latlng}, function(results, status) {
            if (status === google.maps.GeocoderStatus.OK) {
              if (results[1]) {
                callback(200, results[1].formatted_address, obj );
              } else {
                callback(404, "Not found.", obj);
              }
            } else {
              callback(400, "Something wrong went.", obj );
            }
          });
        }
        ';
        /* End geocoding reverse method */

        // Minify the Javascript if the $minifyJS config value is true. Requires Jsmin.php and PHP 5+
        if ($this->minifyJS) {
            $CI = \App::make('jsmin');
            $this->output_js_contents = $CI->jsmin->min($this->output_js_contents);
        }

        if ($this->jsfile == "") {
            $this->output_js .= $this->output_js_contents;
        } else { // if needs writing to external js file
            if (!$handle = fopen($this->jsfile, "w")) {
                $this->output_js .= $this->output_js_contents;
            } else {
                if (!fwrite($handle, $this->output_js_contents)) {
                    $this->output_js .= $this->output_js_contents;
                } else {
                    $this->output_js .= '
                    <script src="'.$this->jsfile.'" type="text/javascript"></script>';
                }
            }
        }

        if ($this->jsfile == "") {
            $this->output_js .= '
            //]]>
            </script>';
        }

        // set height and width
        if (is_numeric($this->map_width)) { // if no width type set
            $this->map_width = $this->map_width.'px';
        }
        if (is_numeric($this->map_height)) { // if no height type set
            $this->map_height = $this->map_height.'px';
        }
        //

        $this->output_html .= '<div id="'.$this->map_div_id.'" style="width:'.$this->map_width.'; height:'.$this->map_height.';"'.(($this->class != "") ? ' class="'.$this->class.'"' : '').'></div>';

        ++$this->maps_loaded;

        return array('js' => $this->output_js, 'html' => $this->output_html, 'markers' => $this->markersInfo);
    }

    public function is_lat_long($input)
    {
        $input = str_replace(", ", ",", trim($input));
        $input = explode(",", $input);
        if (count($input) == 2) {
            if (is_numeric($input[0]) && is_numeric($input[1])) { // is a lat long
                return true;
            } else { // not a lat long - incorrect values
                return false;
            }
        } else { // not a lat long - too many parts
            return false;
        }
    }

    public function get_lat_long_from_address($address, $attempts = 0)
    {
        $lat = 0;
        $lng = 0;

        $error = '';

        if ($this->geocodeCaching) { // if caching of geocode requests is activated

            $geocache = DB::table($this->geoCacheTableName)->select("latitude","longitude")->where("address", trim(strtolower($address)))->first();

            if ($geocache) {

                return array($geocache->latitude, $geocache->longitude);
            }
        }

        $data_location = "https://maps.google.com/maps/api/geocode/json?address=".urlencode(utf8_encode($address))."&sensor=".$this->sensor;
        if ($this->region != "" && strlen($this->region) == 2) {
            $data_location .= "&region=".$this->region;
        }

        $context = null;
        $proxy = config('googlemaps.http_proxy');
        if (!empty($proxy)) {
            $context = stream_context_create([
                'http' => [
                    'proxy' => $proxy,
                    'request_fulluri' => true,
                ]
            ]);
        }

        $data = file_get_contents($data_location, false, $context);

        $data = json_decode($data);

        if ($data->status == "OK") {
            $lat = $data->results[0]->geometry->location->lat;
            $lng = $data->results[0]->geometry->location->lng;

            if ($this->geocodeCaching) { // if we to need to cache this result
                if ($address != "" && $lat != 0 && $lng != 0) {
                    $data = array(
                        "address" => trim(strtolower($address)),
                        "latitude" => $lat,
                        "longitude" => $lng,
                    );
                    DB::table($this->geoCacheTableName)->insert($data);
                }
            }
        } else {
            if ($data->status == "OVER_QUERY_LIMIT") {
                $error = $data->status;
                if ($attempts < 2) {
                    sleep(1);
                    ++$attempts;
                    list($lat, $lng, $error) = $this->get_lat_long_from_address($address, $attempts);
                }
            }
        }

        return array($lat, $lng, $error);
    }


    /**
     * This method will check markers are inside geofence or not
     * @param $polygon array() -- polygon first and last value of array should be same otherwise result will be accurate
     * @param $latlngs  array()
     *
     * return @array
     *
     * EXAMPLE:::
     * $latlngs = array("50,70","70,40","-20,30","100,10","-10,-10","40,-20","110,-20");
     * $polygon = array("-50,30","50,70","100,50","80,10","110,-10","110,-30","-20,-50","-30,-40","10,-10","-10,10","-30,-20","-50,30");
     */
    public function isMarkerInsideGeofence($polygon, $latlngs){
        $cls = new isInsidePolygon();
        $output = [];
        foreach($latlngs as $key => $point) {
            $output[$key] = $cls->pointInPolygon($point, $polygon);
        }
        return $output;
    }

    public function getMapName(){
        return $this->map_name;
    }
}
